/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.io.IOException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.issue.JiraIssueCreator;
import net.sf.sahi.report.HtmlReporter;
import net.sf.sahi.report.JunitReporter;
import net.sf.sahi.report.TM6Reporter;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheHttpResponse;
import net.sf.sahi.session.Session;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.SahiTestSuite;
import net.sf.sahi.util.BrowserType;
import net.sf.sahi.util.BrowserTypesLoader;

public class Suite {
    public void start(HttpRequest request) {
        if (request.getParameter("browserType") != null) {
            this.startPreconfiguredBrowser(request);
            return;
        }
        Session session = request.session();
        String suitePath = request.getParameter("suite");
        String base = request.getParameter("base");
        String browser = request.getParameter("browser");
        String browserOption = request.getParameter("browserOption");
        String browserProcessName = request.getParameter("browserProcessName");
        String threads = request.getParameter("threads");
        String systemProxy = request.getParameter("useSystemProxy");
        Boolean useSystemProxy = false;
        if (systemProxy != null) {
            useSystemProxy = "true".equals(systemProxy);
        }
        this.launch(suitePath, base, browser, session.id(), browserOption, browserProcessName, threads, useSystemProxy, request);
    }

    public void startPreconfiguredBrowser(HttpRequest request) {
        BrowserTypesLoader browserLoader = new BrowserTypesLoader();
        BrowserType browserType = browserLoader.getBrowserType(request);
        Session session = request.session();
        String suitePath = request.getParameter("suite");
        String base = request.getParameter("base");
        int threads = this.getThreads(request.getParameter("threads"), browserType.capacity());
        if (browserType != null) {
            this.launch(suitePath, base, browserType.path(), session.id(), browserType.options(), browserType.processName(), "" + threads, browserType.useSystemProxy(), request);
        }
    }

    private int getThreads(String threadsStr, int capacity) {
        int threads = 1;
        try {
            threads = Integer.parseInt(threadsStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        return threads < capacity ? threads : capacity;
    }

    private void launch(String suitePath, String base, String browser, String sessionId, String browserOption, String browserProcessName, String threadCapacity, boolean useSystemProxy, HttpRequest request) {
        final SahiTestSuite suite = new SahiTestSuite(Configuration.getAbsoluteUserPath(suitePath), base, browser, sessionId, browserOption, browserProcessName);
        int threads = 1;
        try {
            threads = Integer.parseInt(threadCapacity);
        }
        catch (Exception e) {
            // empty catch block
        }
        suite.setAvailableThreads(threads);
        suite.setUseSystemProxy(useSystemProxy);
        try {
            Configuration.copyProfiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        suite.setExtraInfo(request.getParameter("extraInfo"));
        suite.setInitJS(request.getParameter("initJS"));
        this.setReporters(suite, request);
        this.setIssueCreators(suite, request);
        new Thread(){

            public void run() {
                suite.run();
            }
        }.start();
    }

    private void setIssueCreators(SahiTestSuite suite, HttpRequest request) {
        String propFile = request.getParameter("jira");
        if (propFile != null) {
            suite.addIssueCreator(new JiraIssueCreator(propFile));
        }
    }

    public HttpResponse status(HttpRequest request) {
        Session session = request.session();
        Status status = session.getStatus();
        if (status == null) {
            status = Status.FAILURE;
        }
        return new NoCacheHttpResponse(status.getName());
    }

    private void setReporters(SahiTestSuite suite, HttpRequest request) {
        String logDir = request.getParameter("junit");
        if (logDir != null) {
            if (!logDir.equals("")) {
                logDir = Configuration.getAbsoluteUserPath(logDir);
            }
            suite.addReporter(new JunitReporter(logDir));
        }
        if ((logDir = request.getParameter("html")) != null) {
            if (!logDir.equals("")) {
                logDir = Configuration.getAbsoluteUserPath(logDir);
            }
            suite.addReporter(new HtmlReporter(logDir));
        }
        if ((logDir = request.getParameter("tm6")) != null) {
            if (!logDir.equals("")) {
                logDir = Configuration.getAbsoluteUserPath(logDir);
            }
            suite.addReporter(new TM6Reporter(logDir));
        }
    }

    public void kill(HttpRequest request) {
        Session session = request.session();
        SahiTestSuite suite = SahiTestSuite.getSuite(session.id());
        if (suite != null) {
            suite.kill();
        }
    }
}

