/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.report;

import java.text.DateFormat;
import java.util.List;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.report.Formatter;
import net.sf.sahi.report.ResultType;
import net.sf.sahi.report.TestResult;
import net.sf.sahi.report.TestSummary;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFormatter
implements Formatter {
    @Override
    public String getFileName(String scriptName) {
        return scriptName + ".htm";
    }

    @Override
    public String getResultData(List<TestResult> listResult) {
        StringBuffer sb = new StringBuffer();
        if (listResult != null && listResult.size() > 0) {
            for (int i = 0; i < listResult.size(); ++i) {
                TestResult result = listResult.get(i);
                sb.append(this.getStringResult(result)).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String getHeader() {
        return new StringBuffer("<head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\" />\n<style>\n").append(new String(Utils.readFile(Configuration.getPlaybackLogCSSFileName(true)))).append(new String(Utils.readFile(Configuration.getConsolidatedLogCSSFileName(true)))).append("</style></head>\n").toString();
    }

    public String getStringResult(TestResult result) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div class=\"").append(result.type.getName()).append("\"><a class=\"").append(result.type.getName());
        String title = result.debugInfo;
        if (title == null) {
            title = "";
        }
        if (!Utils.isBlankOrNull(title)) {
            sb.append("\" href=\"/_s_/dyn/").append("Log_highlight").append("?href=").append(title).append("#selected");
        }
        sb.append("\" title=\"" + title + "\">").append(result.message.trim().replaceAll("\n", "<br/>")).append(result.failureMsg != null ? "<br/>" + result.failureMsg.trim().replaceAll("\n", "<br/>") : "").append("</a> <span class='extra'> at " + DateFormat.getDateTimeInstance().format(result.time) + "</span>" + "</div>");
        return sb.toString();
    }

    @Override
    public String getSummaryHeader() {
        return "<table><tr><td>Test</td><td>Total Steps</td><td>Failures</td><td>Errors</td><td>Success Rate</td><td>Time Taken (ms)</td></tr>";
    }

    @Override
    public String getSummaryData(TestSummary summary) {
        StringBuffer sb = new StringBuffer();
        int successRate = summary.getSteps() != 0 ? (summary.getSteps() - (summary.getFailures() + summary.getErrors())) * 100 / summary.getSteps() : 100;
        sb.append("<tr class=\"");
        sb.append(summary.hasFailed() ? ResultType.FAILURE.getName() : ResultType.SUCCESS.getName());
        sb.append("\"><td>");
        if (summary.addLink()) {
            sb.append("<a class=\"SCRIPT\" href=\"").append(this.getFileName(summary.getLogFileName())).append("\">").append(summary.getScriptName()).append("</a>");
        } else {
            sb.append(summary.getScriptName());
        }
        sb.append("</td><td>").append(summary.getSteps()).append("</td><td>").append(summary.getFailures()).append("</td><td>").append(summary.getErrors()).append("</td><td>").append(successRate).append("%</td><td>").append(summary.getTimeTaken()).append("</td></tr>");
        return sb.toString();
    }

    @Override
    public String getSummaryFooter() {
        return "</table>";
    }

    @Override
    public String getFooter() {
        return "";
    }

    @Override
    public String getSuiteLogFileName() {
        return "index";
    }

    @Override
    public String getStartScript() {
        return "\n<br/><div class=\"START\"><a class=\"START\">Starting script</a></div>";
    }

    @Override
    public String getStopScript() {
        return "<div class=\"STOP\"><a class=\"STOP\">Stopping script</a></div>";
    }
}

