/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.report.Formatter;
import net.sf.sahi.report.Report;
import net.sf.sahi.report.TestSummary;
import net.sf.sahi.rhino.RhinoScriptRunner;
import net.sf.sahi.test.TestLauncher;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SahiReporter {
    protected Formatter formatter;
    protected String logDir;
    protected String suiteName;
    protected Writer suiteWriter;

    public SahiReporter(String logDir, Formatter formatter) {
        this.logDir = logDir;
        this.formatter = formatter;
    }

    public SahiReporter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public void generateSuiteReport(List<TestLauncher> tests) {
        try {
            this.createWriter();
            this.suiteWriter.write(this.formatter.getHeader());
            this.suiteWriter.write(this.formatter.getSummaryHeader());
            this.writeTestSummary(tests);
            this.suiteWriter.write(this.formatter.getSummaryFooter());
            this.suiteWriter.write(this.formatter.getFooter());
            this.suiteWriter.flush();
            this.suiteWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeTestSummary(List<TestLauncher> origtests) throws IOException {
        ArrayList<TestLauncher> tests = new ArrayList<TestLauncher>(origtests);
        Iterator iter = tests.iterator();
        while (iter.hasNext()) {
            try {
                TestSummary summary;
                Report report;
                TestLauncher test = (TestLauncher)iter.next();
                RhinoScriptRunner scriptRunner = test.getScriptRunner();
                if (scriptRunner == null || (report = scriptRunner.getReport()) == null || (summary = report.getTestSummary()) == null) continue;
                summary.setAddLink(true);
                this.suiteWriter.write(this.formatter.getSummaryData(summary));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void createWriter() throws IOException {
        this.suiteWriter = this.createWriter(this.formatter.getSuiteLogFileName());
    }

    protected Writer createWriter(String file) throws IOException {
        File dir = new File(this.getLogDir());
        Configuration.createFolders(dir);
        File logFile = new File(dir, this.formatter.getFileName(file));
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF8"));
    }

    public void generateTestReport(Report report) {
        try {
            String logFileName = report.getTestSummary().getLogFileName();
            if (new File(logFileName).exists()) {
                return;
            }
            Writer writer = this.createWriter(logFileName);
            writer.write(this.formatter.getHeader());
            writer.write(this.formatter.getSummaryHeader());
            writer.write(this.formatter.getSummaryData(report.getTestSummary()));
            writer.write(this.formatter.getSummaryFooter());
            writer.write(this.formatter.getStartScript());
            writer.write(this.formatter.getResultData(report.getListResult()));
            writer.write(this.formatter.getStopScript());
            writer.write(this.formatter.getFooter());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getLogDir() {
        if (Utils.isBlankOrNull(this.logDir)) {
            this.logDir = this.createSuiteLogFolder() ? Configuration.appendLogsRoot(Utils.createLogFileName(this.suiteName)) : Configuration.getPlayBackLogsRoot();
        }
        return this.logDir;
    }

    public abstract boolean createSuiteLogFolder();

    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }
}

