/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.sahi.StreamHandler;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.session.Session;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends StreamHandler {
    private String host;
    private int port;
    private String uri;
    private String queryString = "";
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, String> cookies = null;
    private static final Logger logger = Logger.getLogger("net.sf.sahi.request.HttpRequest");
    private boolean isSSLSocket;
    private boolean isAjax;
    private String fileExtension;
    private String hostWithPort;
    private String fileName;
    private Session session;
    private String sahiCookie;

    HttpRequest() {
    }

    public HttpRequest(InputStream in) throws IOException {
        this(in, false);
    }

    public HttpRequest(InputStream in, boolean isSSLSocket) throws IOException {
        this.isSSLSocket = isSSLSocket;
        this.populateHeaders(in, true);
        boolean bl = this.isAjax = this.hasHeader("sahi-isxhr") || this.isAjaxHeaderPresent() || this.isMicrosoftAjaxHeaderPresent();
        if (this.isPost() || this.isPut()) {
            this.populateData(in);
        }
        if (this.isPost() || this.isGet() || this.isPut() || this.isDelete() || this.isConnect()) {
            this.setHostAndPort();
            this.setUri();
            this.setQueryString();
        }
        this.handleSahiCookie();
    }

    private boolean isMicrosoftAjaxHeaderPresent() {
        String xReqWith = this.getLastSetValueOfHeader("x-microsoftajax");
        return "Delta=true".equals(xReqWith);
    }

    private boolean isAjaxHeaderPresent() {
        String xReqWith = this.getLastSetValueOfHeader("X-Requested-With");
        return "XMLHttpRequest".equals(xReqWith);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isPost() {
        return "post".equalsIgnoreCase(this.method());
    }

    public boolean isPut() {
        return "put".equalsIgnoreCase(this.method());
    }

    public boolean isDelete() {
        return "delete".equalsIgnoreCase(this.method());
    }

    public boolean isGet() {
        return "get".equalsIgnoreCase(this.method());
    }

    public boolean isConnect() {
        return "connect".equalsIgnoreCase(this.method());
    }

    public boolean isSSL() {
        return this.isSSLSocket || this.isConnect();
    }

    public String method() {
        if (this.firstLine() == null) {
            return null;
        }
        return this.firstLine().substring(0, this.firstLine().indexOf(" "));
    }

    void setUri() {
        String withHost = this.firstLine().substring(this.firstLine().indexOf(" "), this.firstLine().lastIndexOf(" ")).trim();
        this.uri = this.stripHostName(withHost, this.host, this.isSSL());
    }

    String stripHostName(String withHost, String hostName, boolean ssl) {
        String stripped = withHost;
        if (withHost.startsWith("http://") || withHost.startsWith("https://")) {
            int indexOfSlash = withHost.indexOf("/", withHost.indexOf(hostName));
            stripped = withHost.substring(indexOfSlash);
        }
        return stripped;
    }

    public String uri() {
        return this.uri;
    }

    public String protocol() {
        return this.firstLine().substring(this.firstLine().lastIndexOf(" "));
    }

    private void setHostAndPort() {
        int indexOfColon;
        this.host = this.hostWithPort = this.getLastSetValueOfHeader("Host");
        this.port = 80;
        if (this.isSSL()) {
            this.port = 443;
        }
        if ((indexOfColon = this.hostWithPort.indexOf(":")) != -1) {
            this.host = this.hostWithPort.substring(0, indexOfColon);
            try {
                this.port = Integer.parseInt(this.hostWithPort.substring(indexOfColon + 1).trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.host = Utils.stripChildSessionId(this.host);
    }

    private void setQueryString() {
        int lastSlashIx;
        if (this.uri == null) {
            return;
        }
        int qIx = this.uri.indexOf("?");
        String uriWithoutQueryString = this.uri;
        if (qIx != -1 && qIx + 1 < this.uri.length()) {
            uriWithoutQueryString = this.uri.substring(0, qIx);
            this.queryString = this.uri.substring(qIx + 1);
        }
        this.fileExtension = "";
        int dotIx = uriWithoutQueryString.indexOf(".");
        if (dotIx != -1) {
            this.fileExtension = uriWithoutQueryString.substring(dotIx + 1);
        }
        if ((lastSlashIx = uriWithoutQueryString.lastIndexOf("/")) != -1) {
            this.fileName = lastSlashIx + 1 < uriWithoutQueryString.length() ? uriWithoutQueryString.substring(lastSlashIx + 1) : "no_filename";
        }
    }

    private void setGetParameters() {
        try {
            this.setGetParameters(this.queryString());
            if (this.isPost()) {
                this.setGetParameters(new String(this.data(), "UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setGetParameters(String paramStr) {
        paramStr = paramStr.replaceAll("__SahiAmpersandSahi__", "&");
        StringTokenizer tokenizer = new StringTokenizer(paramStr, "&");
        while (tokenizer.hasMoreTokens()) {
            String keyVal = tokenizer.nextToken();
            int eqIx = keyVal.indexOf(61);
            if (eqIx == -1) continue;
            String key = keyVal.substring(0, eqIx);
            String value = "";
            if (eqIx + 1 <= keyVal.length()) {
                value = keyVal.substring(eqIx + 1);
            }
            try {
                this.params.put(key, URLDecoder.decode(value, "UTF8"));
            }
            catch (Exception e) {
                this.params.put(key, value);
            }
        }
    }

    public String queryString() {
        return this.queryString;
    }

    public String getParameter(String key) {
        if (this.params.size() == 0) {
            this.setGetParameters();
        }
        return this.params.get(key);
    }

    String rebuildCookies() {
        return HttpRequest.rebuildCookies(this.cookies);
    }

    static String rebuildCookies(Map<String, String> cookies2) {
        StringBuilder sb = new StringBuilder();
        if (cookies2.size() == 0) {
            return "";
        }
        for (String key : cookies2.keySet()) {
            String value = cookies2.get(key);
            sb.append(" ").append(key).append("=").append(value).append(";");
        }
        String cookieStr = sb.toString().trim();
        if (cookieStr.endsWith(";")) {
            cookieStr = cookieStr.substring(0, cookieStr.length() - 1);
        }
        return cookieStr;
    }

    public HttpRequest modifyForFetch() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("REQUEST HEADERS BEFORE MODIFICATION");
            logger.finest(new String(this.rawHeaders()));
        }
        this.removeHeader("Proxy-Connection");
        this.removeHeader("Accept-Encoding");
        this.addHeader("Accept-Encoding", "gzip");
        this.removeHeader("Keep-Alive");
        this.removeHeader("sahi-isxhr");
        this.removeHeader("Authorization");
        this.removeHeader("Proxy-Authorization");
        this.resetRawHeaders();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("REQUEST HEADERS AFTER MODIFICATION");
            logger.finest(this.firstLine());
            logger.finest("\n------------\n\nRequest Headers:\n" + this.headers());
        }
        return this;
    }

    public Session session() {
        boolean finest = logger.isLoggable(Level.FINEST);
        if (this.session == null) {
            String sessionId = this.getParameter("sahisid");
            if (finest) {
                logger.finest("SessionId from parameter:" + sessionId);
            }
            if (Utils.isBlankOrNull(sessionId)) {
                sessionId = this.sahiCookie;
                if (finest) {
                    logger.finest("SessionId from cookie:" + sessionId);
                }
            }
            if (Utils.isBlankOrNull(sessionId)) {
                sessionId = Utils.generateId();
                if (finest) {
                    logger.finest("SessionId generated:" + sessionId);
                }
            }
            this.session = Session.getInstance(sessionId);
        }
        return this.session;
    }

    void handleSahiCookie() {
        String cookieString = this.getLastSetValueOfHeader("Cookie");
        if (Utils.isBlankOrNull(cookieString)) {
            return;
        }
        int ix = cookieString.indexOf("sahisid=");
        if (ix == -1) {
            this.sahiCookie = "";
        } else {
            String stripped;
            int endIx = cookieString.indexOf(";", ix + 1);
            int length = cookieString.length();
            if (endIx == -1) {
                this.sahiCookie = cookieString.substring(ix + "sahisid=".length());
                stripped = cookieString.substring(0, ix);
            } else {
                this.sahiCookie = cookieString.substring(ix + "sahisid=".length(), endIx);
                stripped = cookieString.substring(0, ix) + cookieString.substring(endIx + 1, length).trim();
            }
            this.setHeader("Cookie", stripped.trim());
        }
    }

    public String sahiCookie() {
        return this.sahiCookie;
    }

    public String fileExtension() {
        return this.fileExtension;
    }

    public String fileName() {
        return this.fileName;
    }

    public String url() {
        return (this.isSSL() ? "https" : "http") + "://" + this.hostWithPort + (this.uri == null ? "" : this.uri);
    }

    public boolean isMultipart() {
        String contentType = this.getLastSetValueOfHeader("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public void setSSL(boolean isSSL) {
        this.isSSLSocket = isSSL;
    }

    public boolean isIE() {
        String agent = this.getLastSetValueOfHeader("User-Agent");
        return agent == null || agent.indexOf("MSIE") != -1;
    }

    public boolean isAjax() {
        return this.isAjax;
    }

    public String referer() {
        String header = this.headers().getLastHeader("referer");
        return header;
    }

    public boolean isExcluded() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("isAjax=" + this.isAjax + " for " + this.url());
        }
        if (this.isAjax) {
            return true;
        }
        String url = this.url();
        String[] exclusionList = Configuration.getExclusionList();
        for (int i = 0; i < exclusionList.length; ++i) {
            String pattern = exclusionList[i];
            if (!url.matches(pattern.trim())) continue;
            return true;
        }
        return false;
    }
}

