/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.session;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.sahi.command.MockResponder;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.RequestCredentials;
import net.sf.sahi.playback.SahiScript;
import net.sf.sahi.record.Recorder;
import net.sf.sahi.report.Report;
import net.sf.sahi.rhino.ScriptRunner;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.BrowserLauncher;
import net.sf.sahi.test.SahiTestSuite;
import net.sf.sahi.util.Utils;

public class Session {
    private static final Logger logger = Logger.getLogger("net.sf.sahi.session.Session");
    private final Hashtable<String, String> ajaxRedirects = new Hashtable();
    private Status status;
    private static Map<String, Session> sessions = new HashMap<String, Session>();
    private String sessionId;
    private boolean isWindowOpen = false;
    private Recorder recorder;
    private SahiScript script;
    private Map<String, String> variables;
    private MockResponder mockResponder = new MockResponder();
    private Report report;
    private long timestamp = System.currentTimeMillis();
    private ScriptRunner scriptRunner;
    private Map<String, RequestCredentials> requestCredentials = new HashMap<String, RequestCredentials>();
    private BrowserLauncher launcher;
    private boolean isPlaying;
    private boolean isRecording;
    private boolean isReadyForDriver;
    private Map<String, Object> objectVariables = new HashMap<String, Object>();
    private boolean is204;

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public static void removeInstance(String sessionId) {
        sessions.remove(sessionId);
    }

    public static synchronized Session getInstance(String sessionId) {
        if (!sessions.containsKey(sessionId)) {
            sessions.put(sessionId, new Session(sessionId));
        }
        Session session = sessions.get(sessionId);
        session.touch();
        return session;
    }

    public static synchronized Session getExistingInstance(String sessionId) {
        return sessions.get(sessionId);
    }

    public Session(String sessionId) {
        this.sessionId = sessionId;
        this.variables = new HashMap<String, String>();
        this.status = Status.INITIAL;
    }

    public String id() {
        return this.sessionId;
    }

    public void setIsWindowOpen(boolean isWindowOpen) {
        this.isWindowOpen = isWindowOpen;
    }

    public boolean isWindowOpen() {
        return this.isWindowOpen;
    }

    public Recorder getRecorder() {
        if (this.recorder == null) {
            this.recorder = new Recorder();
        }
        return this.recorder;
    }

    public String getVariable(String name) {
        return this.variables.get(name);
    }

    public void removeVariables(String pattern) {
        Iterator<String> iterator = this.variables.keySet().iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!s.matches(pattern)) continue;
            iterator.remove();
        }
    }

    public void setVariable(String name, String value) {
        this.variables.put(name, value);
        if (this.scriptRunner != null) {
            this.scriptRunner.setVariable(name, value);
        }
    }

    public SahiScript xgetScript() {
        return this.script;
    }

    public SahiTestSuite getSuite() {
        return SahiTestSuite.getSuite(this.id());
    }

    public MockResponder mockResponder() {
        return this.mockResponder;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setIsPlaying(boolean isPlaying) {
        this.isPlaying = isPlaying;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void touch() {
        this.timestamp = System.currentTimeMillis();
    }

    public long lastActiveTime() {
        return this.timestamp;
    }

    public ScriptRunner getScriptRunner() {
        return this.scriptRunner;
    }

    public void setScriptRunner(ScriptRunner scriptRunner) {
        this.scriptRunner = scriptRunner;
        scriptRunner.setSession(this);
    }

    public void setLauncher(BrowserLauncher launcher) {
        this.launcher = launcher;
    }

    public BrowserLauncher getLauncher() {
        return this.launcher;
    }

    public void addRequestCredentials(String realm, String username, String password) {
        realm = realm.trim();
        logger.info(">>> Credentials added: " + realm + " " + username);
        this.requestCredentials.put(realm, new RequestCredentials(realm, username, password));
    }

    public void removeRequestCredentials(String realm) {
        this.requestCredentials.remove(realm);
    }

    public void removeAllRequestCredentials() {
        this.requestCredentials.clear();
    }

    public RequestCredentials getMatchingCredentials(String realm, String scheme) {
        String key = Utils.isBlankOrNull(realm) ? scheme : realm;
        RequestCredentials cred = this.requestCredentials.get(key.trim());
        if (cred == null || cred.used()) {
            return null;
        }
        return cred;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setIsRecording(boolean isRecording) {
        this.isRecording = isRecording;
    }

    public void setIsReadyForDriver(boolean isReadyForDriver) {
        this.isReadyForDriver = isReadyForDriver;
    }

    public boolean isReadyForDriver() {
        return this.isReadyForDriver;
    }

    public boolean isPaused() {
        return "1".equals(this.getVariable("sahi_paused"));
    }

    public String getInfoJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("'isRecording':" + this.isRecording());
        sb.append(",");
        sb.append("'isPlaying':" + this.isPlaying());
        sb.append(",");
        sb.append("'isPaused':" + this.isPaused());
        sb.append(",");
        sb.append("'sessionId':'" + this.sessionId + "'");
        sb.append("}");
        return sb.toString();
    }

    public static void removeInactiveSessions() {
        long timeNow = System.currentTimeMillis();
        double inactiveTimeout = (double)Configuration.getMaxInactiveTimeForScript() * 1.5;
        try {
            Iterator<Session> iterator = sessions.values().iterator();
            while (iterator.hasNext()) {
                Session s = iterator.next();
                if (!((double)(timeNow - s.lastActiveTime()) > inactiveTimeout)) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.gc();
    }

    public void setObject(String key, Object value) {
        this.objectVariables.put(key, value);
    }

    public Object getObject(String key) {
        return this.objectVariables.get(key);
    }

    public void addAjaxRedirect(String redirectedTo) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding AJAX redirect for: " + redirectedTo);
        }
        this.ajaxRedirects.put(redirectedTo, redirectedTo);
    }

    public boolean isAjaxRedirect(String url) {
        boolean isRedirect = this.ajaxRedirects.containsKey(url);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("AJAX redirect for: " + url + ": " + isRedirect);
        }
        if (isRedirect) {
            this.ajaxRedirects.remove(url);
        }
        return isRedirect;
    }

    public void set204(boolean is204) {
        this.is204 = is204;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Setting is204 = " + is204);
        }
    }

    public boolean is204() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("is204 = " + this.is204);
        }
        return this.is204;
    }

    static {
        Timer stepTimer = new Timer();
        stepTimer.schedule(new TimerTask(){

            public void run() {
                Session.removeInactiveSessions();
            }
        }, 0L, 10000L);
    }
}

