/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.stream.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.stream.filter.StreamFilter;
import net.sf.sahi.util.Utils;

public class HTMLModifierFilter
extends StreamFilter {
    private String charset;
    private boolean isXHTML;
    private final boolean isSSL;
    private boolean injected;
    private static String INJECT_TOP_SSL = null;
    private static String INJECT_BOTTOM_SSL = null;
    private static String INJECT_TOP;
    private static String INJECT_BOTTOM;
    private String leftOver = "";

    private static void initializeInjects() {
        INJECT_TOP = new String(Utils.readFile(Configuration.getInjectTop())).replace("$commonDomain", Configuration.getCommonDomain());
        INJECT_BOTTOM = new String(Utils.readFile(Configuration.getInjectBottom()));
        INJECT_TOP_SSL = HTMLModifierFilter.makeHTTPS(INJECT_TOP);
        INJECT_BOTTOM_SSL = HTMLModifierFilter.makeHTTPS(INJECT_BOTTOM);
    }

    private static String makeHTTPS(String content) {
        return content.replaceAll("http", "https");
    }

    public HTMLModifierFilter(String charset, boolean isXHTML, boolean isSSL) {
        this.charset = charset;
        this.isXHTML = isXHTML;
        this.isSSL = isSSL;
    }

    public byte[] modify(byte[] data) throws IOException {
        return this.injectSahiFiles(data, this.getInjectAtTop());
    }

    public String modify(String dataStr) {
        return this.injectSahiFiles(dataStr, this.getInjectAtTop());
    }

    private byte[] getBytesInCharset(String str) {
        try {
            return str.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str.getBytes();
        }
    }

    protected String getInjectAtTop() {
        return this.isSSL ? INJECT_TOP_SSL : INJECT_TOP;
    }

    protected String getInjectAtBottom() {
        return this.isSSL ? INJECT_BOTTOM_SSL : INJECT_BOTTOM;
    }

    public String injectSahiFiles(String dataStr, String toInject) {
        String sample = dataStr;
        int ix = this.getTagEndIndex(sample.toLowerCase());
        return this.inject(sample, ix + 1, toInject);
    }

    private byte[] injectSahiFiles(byte[] data, String toInject) throws UnsupportedEncodingException {
        if (this.injected) {
            return data;
        }
        String sample = this.leftOver + new String(data, this.charset);
        int ix = -1;
        if (this.isXHTML) {
            ix = this.getTagEndIndex(sample.toLowerCase());
        }
        if (ix == -1) {
            this.leftOver = sample;
            return new byte[0];
        }
        this.injected = true;
        this.leftOver = "";
        return this.getBytesInCharset(this.inject(sample, ix + 1, toInject));
    }

    private String inject(String origStr, int insertAfterIx, String toInject) {
        StringBuilder sb = new StringBuilder();
        sb.append(origStr.substring(0, insertAfterIx));
        sb.append(toInject);
        sb.append(origStr.substring(insertAfterIx));
        return sb.toString();
    }

    public void modifyHeaders(HttpResponse response) {
        response.removeHeader("ETag");
        response.removeHeader("Last-Modified");
        response.removeHeader("WWW-Authenticate");
        response.removeHeader("Proxy-Authenticate");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
    }

    private int getTagEndIndex(String s) {
        int htmlIx = this.getTagEndIndex(s, "<html");
        int headIx = this.getTagEndIndex(s, "<head");
        int ix = this.isXHTML && headIx != -1 ? headIx : htmlIx;
        return ix;
    }

    private int getTagEndIndex(String s, String tag) {
        int ix = s.indexOf(tag);
        if (ix != -1) {
            ix = s.indexOf(">", ix);
        }
        return ix;
    }

    public byte[] getRemaining() {
        if (this.injected) {
            return this.getBytesInCharset(this.isXHTML ? "" : this.getInjectAtBottom());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getInjectAtTop());
        sb.append(this.leftOver);
        if (!this.isXHTML) {
            sb.append(this.getInjectAtBottom());
        }
        return this.getBytesInCharset(sb.toString());
    }

    static {
        HTMLModifierFilter.initializeInjects();
    }
}

