/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.test;

import net.sf.sahi.config.Configuration;
import net.sf.sahi.test.ProcessHelper;
import net.sf.sahi.util.Utils;

public class BrowserLauncher {
    private String browserProcessName;
    private String browser;
    private String browserOption;
    private ProcessHelper process;

    public BrowserLauncher(String browser, String browserProcessName, String browserOption) {
        this.browser = browser;
        this.browserProcessName = browserProcessName;
        this.browserOption = browserOption;
    }

    public ProcessHelper openURL(String url) {
        String cmd = this.buildCommand(url);
        cmd = cmd.replaceAll("%20", " ").replaceAll("[&]", "__SahiAmpersandSahi__");
        cmd = cmd.replaceAll("[$]userDir", Configuration.getUserDataDir().replace('\\', '/'));
        cmd = cmd.replaceAll("[$]threadNo", "0");
        cmd = Utils.expandSystemProperties(cmd);
        this.process = new ProcessHelper(cmd, this.browserProcessName);
        this.process.execute();
        return this.process;
    }

    private String buildCommand(String url) {
        if (Utils.isWindows()) {
            return this.buildCommandForWindows(url);
        }
        return this.buildCommandForNonWindows(url);
    }

    String buildCommandForWindows(String url) {
        String result = "\"" + this.browser + "\" ";
        if (!Utils.isBlankOrNull(this.browserOption)) {
            result = result + this.browserOption;
        }
        result = result + " \"" + url + "\"";
        return result;
    }

    String buildCommandForNonWindows(String url) {
        String result = this.browser.replaceAll("[ ]+", "\\ ");
        if (!Utils.isBlankOrNull(this.browserOption)) {
            result = result + " " + this.browserOption.replaceAll("[ ]+", "\\ ");
        }
        result = result + " " + url;
        return result;
    }

    public void kill() {
        try {
            if (this.process != null) {
                this.process.kill();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

