/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import net.sf.sahi.util.OSUtils;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHelper {
    private static final Logger logger = Logger.getLogger("net.sf.sahi.test.ProcessHelper");
    private String cmd;
    private ArrayList<String> pids;
    private Process process;
    private String imageName;
    static Semaphore lock = new Semaphore(1, true);
    static long t;
    private static boolean hasProcessStarted;

    public ProcessHelper(String cmd, String imageName) {
        this.cmd = cmd;
        this.imageName = imageName;
    }

    public void execute() {
        try {
            try {
                lock.acquire();
                hasProcessStarted = false;
                t = System.currentTimeMillis();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            ArrayList<String> allPIDsBefore = this.getPIDs();
            logger.info(this.cmd);
            String[] tokens = Utils.getCommandTokens(this.cmd.replaceAll("%20", " "));
            this.process = Utils.executeAndGetProcess(tokens);
            new Thread(new PIDGatherer(allPIDsBefore)).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getNewlyAdded(ArrayList<String> oldPIDs, ArrayList<String> newPIDs) {
        ArrayList<String> newlyAdded = new ArrayList<String>();
        for (String pid : newPIDs) {
            if (oldPIDs.contains(pid)) continue;
            newlyAdded.add(pid);
        }
        return newlyAdded;
    }

    ArrayList<String> getPIDs() {
        ArrayList<String> ar = new ArrayList<String>();
        try {
            byte c;
            String listCmd = OSUtils.getPIDListCommand().replaceAll("\\$imageName", this.imageName);
            Process p = Runtime.getRuntime().exec(Utils.getCommandTokens(listCmd));
            InputStream in = p.getInputStream();
            StringBuffer sb = new StringBuffer();
            while ((c = (byte)in.read()) != -1) {
                sb.append((char)c);
            }
            String output = sb.toString();
            StringTokenizer tokenizer = new StringTokenizer(output, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (!(line = line.replaceAll("\\s+", " ").trim()).equals("")) {
                    StringTokenizer spaceTokenizer = new StringTokenizer(line);
                    int i = 0;
                    int colNo = OSUtils.getPIDListColumnNo();
                    boolean hasCol = false;
                    String pid = null;
                    while (spaceTokenizer.hasMoreTokens()) {
                        pid = spaceTokenizer.nextToken();
                        if (++i != colNo) continue;
                        hasCol = true;
                        break;
                    }
                    if (!hasCol) continue;
                    ar.add(pid);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ar;
    }

    public static void main(String[] args) {
    }

    public void kill() {
        logger.info("Kill: " + this.pids);
        for (int i = 0; i < 4; ++i) {
            this.killPIDs();
            if (!this.waitTillPIDsGone(this.pids, 3000)) continue;
            return;
        }
    }

    private void killPIDs() {
        for (String pid : this.pids) {
            try {
                String killCmd = OSUtils.getPIDKillCommand().replaceAll("\\$pid", pid);
                Process killer = Runtime.getRuntime().exec(Utils.getCommandTokens(killCmd));
                killer.waitFor();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean waitTillPIDsGone(ArrayList<String> pids2, int maxTime) {
        int time = 0;
        int interval = 0;
        while (time <= maxTime) {
            ArrayList<String> allPIDs = this.getPIDs();
            Iterator<String> it = pids2.iterator();
            boolean allDone = true;
            while (it.hasNext()) {
                String pid = it.next();
                if (!allPIDs.contains(pid)) continue;
                allDone = false;
            }
            if (allDone) {
                return true;
            }
            time += (interval += 100);
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void setProcessStarted() {
        hasProcessStarted = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PIDGatherer
    implements Runnable {
        private final ArrayList<String> allPIDsBefore;

        PIDGatherer(ArrayList<String> allPIDsBefore) {
            this.allPIDsBefore = allPIDsBefore;
        }

        @Override
        public void run() {
            int maxTime = 30000;
            int interval = 100;
            for (int time = 0; !hasProcessStarted && time < maxTime; time += interval) {
                try {
                    Thread.sleep(interval);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                ArrayList<String> allPIDsAfter = ProcessHelper.this.getPIDs();
                ProcessHelper.this.pids = ProcessHelper.this.getNewlyAdded(this.allPIDsBefore, allPIDsAfter);
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.info("PIDs: " + ProcessHelper.this.pids + "; " + (System.currentTimeMillis() - t) + " ms");
            lock.release();
        }
    }
}

