/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.test;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Logger;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.ScriptFactory;
import net.sf.sahi.rhino.RhinoScriptRunner;
import net.sf.sahi.session.Session;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.BrowserLauncher;
import net.sf.sahi.util.Utils;

public class TestLauncher {
    private final String scriptName;
    private final String startURL;
    private String sessionId;
    private String childSessionId;
    private String browser;
    private static Logger logger = Configuration.getLogger("net.sf.sahi.test.TestLauncher");
    private String browserOption;
    private int threadNo;
    private boolean isMultiThreaded;
    private RhinoScriptRunner scriptRunner;
    private String browserProcessName;
    private BrowserLauncher browserLauncher;

    public TestLauncher(String scriptName, String startURL) {
        this.scriptName = scriptName;
        this.startURL = startURL;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.childSessionId = this.createChildSessionId();
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public void setBrowserOption(String browserOption) {
        this.browserOption = browserOption;
    }

    private String createChildSessionId() {
        return this.sessionId + "sahix" + Utils.getUUID() + "x";
    }

    public String getStartURL() {
        return this.startURL;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void execute(Session session) {
        this.execute(session, true, true);
    }

    public void execute(Session session, boolean async, boolean setDefaultReporters) {
        System.out.println("#### Running Script: " + this.scriptName);
        this.scriptRunner = new RhinoScriptRunner(new ScriptFactory().getScript(this.scriptName), session.getSuite(), this, setDefaultReporters);
        session.setScriptRunner(this.scriptRunner);
        String url = this.addSessionId(this.getURL());
        this.browserOption = this.browserOption == null ? "" : this.browserOption.replaceAll("[$]threadNo", "" + this.threadNo).replaceAll("[$]userDir", Configuration.getAbsoluteUserPath(".").replace('\\', '/'));
        this.browserLauncher = new BrowserLauncher(this.browser, this.browserProcessName, this.browserOption);
        this.browserLauncher.openURL(url);
        if (async) {
            this.scriptRunner.execute();
        } else {
            this.scriptRunner.executeAndWait();
        }
    }

    private String getURL() {
        String cmd = null;
        try {
            cmd = "http://" + Configuration.getCommonDomain() + "/_s_/dyn/Player_auto?file=" + URLEncoder.encode(this.scriptName, "UTF8") + "&startUrl=" + URLEncoder.encode(this.startURL, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return cmd;
    }

    private String addSessionId(String url) {
        return url + "&sahisid=" + this.childSessionId;
    }

    public void kill() {
        System.out.println("Killing " + this.scriptName);
        logger.fine("Killing " + this.scriptName);
        this.browserLauncher.kill();
    }

    public String getChildSessionId() {
        return this.childSessionId;
    }

    public void setThreadNo(int threadNo, boolean isMultiThreaded) {
        this.threadNo = threadNo;
        this.isMultiThreaded = isMultiThreaded;
    }

    public int getThreadNo() {
        return this.threadNo;
    }

    public Status getStatus() {
        return this.scriptRunner.getScriptStatus();
    }

    public RhinoScriptRunner getScriptRunner() {
        return this.scriptRunner;
    }

    public void setBrowserProcessName(String browserProcessName) {
        this.browserProcessName = browserProcessName;
    }
}

