/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import net.sf.sahi.Proxy;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.ui.LinkButton;
import net.sf.sahi.util.BrowserType;
import net.sf.sahi.util.BrowserTypesLoader;
import net.sf.sahi.util.ProxySwitcher;
import net.sf.sahi.util.Utils;

public class Dashboard
extends JFrame {
    private static final long serialVersionUID = 8348788972744726483L;
    private Proxy currentInstance;
    private JPanel masterPanel;
    private int browserTypesHeight;

    public Dashboard() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Sahi Dashboard");
        this.startProxy();
        this.buildUI();
        this.addOnExit();
        Dimension dashboardSize = new Dimension(200, 225 + this.browserTypesHeight);
        this.setSize(dashboardSize);
        this.setPreferredSize(dashboardSize);
        this.setVisible(true);
    }

    private void startProxy() {
        Proxy proxy;
        this.currentInstance = proxy = new Proxy(Configuration.getPort());
        proxy.start(true);
    }

    private void buildUI() {
        this.masterPanel = new JPanel();
        this.masterPanel.setBackground(new Color(255, 255, 255));
        this.masterPanel.add(Box.createRigidArea(new Dimension(120, 5)));
        this.masterPanel.add(this.getBrowserButtons());
        this.masterPanel.add(Box.createRigidArea(new Dimension(120, 15)));
        this.masterPanel.add(this.getLogo());
        this.masterPanel.add(Box.createRigidArea(new Dimension(120, 15)));
        this.masterPanel.add(this.getLinksPanel());
        this.add(this.masterPanel);
    }

    private Component getLinksPanel() {
        LinkButton link = new LinkButton("Configure", "http://localhost:9999/_s_/dyn/ConfigureUI");
        LinkButton link2 = new LinkButton("Scripts", Configuration.getScriptRoots()[0]);
        LinkButton link3 = new LinkButton("Logs", "http://localhost:9999/logs/");
        JPanel buttonPane = new JPanel();
        buttonPane.setBackground(new Color(255, 255, 255));
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(link);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(link2);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(link3);
        return buttonPane;
    }

    private Component getLogo() {
        JLabel picLabel = new JLabel();
        picLabel.setIcon(new ImageIcon(this.getImageBytes("sahi_os_logo2.png"), ""));
        return picLabel;
    }

    private JPanel getBrowserButtons() {
        JPanel panel = new JPanel();
        GridLayout layout = new GridLayout(0, 1, 0, 10);
        panel.setLayout(layout);
        Border innerBorder = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        Border outerBorder = BorderFactory.createEtchedBorder(1);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(compoundBorder, "Launch Browser");
        panel.setBorder(titleBorder);
        this.add(panel);
        Map<String, BrowserType> browserTypes = BrowserTypesLoader.getAvailableBrowserTypes(false);
        if (browserTypes.size() == 0) {
            JLabel label = new JLabel("<html><b>No usable browsers<br>found in<br>browser_types.xml</b>.<br><br> Click on the<br><u>Configure</u> link below<br>to add/edit browsers.</html>");
            label.setSize(120, 100);
            panel.add(label);
            this.browserTypesHeight = 100;
        } else {
            for (String name : browserTypes.keySet()) {
                BrowserType browserType = browserTypes.get(name);
                this.addButton(browserType, panel);
            }
            this.browserTypesHeight = browserTypes.size() * 50;
        }
        panel.setBackground(new Color(255, 255, 255));
        return panel;
    }

    private Component getSahiButtons() {
        final JToggleButton toggleButton = new JToggleButton("Stop Sahi", true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean selected = abstractButton.getModel().isSelected();
                if (selected) {
                    Dashboard.this.startProxy();
                    toggleButton.setText("Stop Sahi");
                } else {
                    Dashboard.this.stopProxy();
                    toggleButton.setText("Start Sahi");
                }
            }
        };
        toggleButton.addActionListener(actionListener);
        Dimension dimension = new Dimension(140, 40);
        toggleButton.setSize(dimension);
        toggleButton.setPreferredSize(dimension);
        return toggleButton;
    }

    private void setIcon(AbstractButton button, String iconFile) {
        if (iconFile == null) {
            return;
        }
        button.setIcon(new ImageIcon(this.getImageBytes(iconFile), ""));
        button.setHorizontalAlignment(2);
    }

    private byte[] getImageBytes(String iconFile) {
        try {
            InputStream resourceAsStream = Dashboard.class.getResourceAsStream("/net/sf/sahi/resources/" + iconFile);
            return Utils.getBytes(resourceAsStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private void addOnExit() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Dashboard.this.stopProxy();
                System.exit(0);
            }
        });
    }

    private void addButton(final BrowserType browserType, JPanel panel) {
        JButton button = new JButton();
        button.setText(browserType.displayName());
        this.setIcon(button, browserType.icon());
        Dimension dimension = new Dimension(120, 40);
        button.setSize(dimension);
        button.setPreferredSize(dimension);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    public void run() {
                        if (browserType.useSystemProxy()) {
                            ProxySwitcher.setSahiAsProxy();
                        }
                        String browserExeCmd = browserType.path();
                        String browserOption = browserType.options();
                        if (browserOption != null) {
                            browserExeCmd = browserExeCmd + " " + browserOption;
                        }
                        browserExeCmd = browserExeCmd.replace("$userDir", Configuration.getUserDataDir());
                        browserExeCmd = browserExeCmd.replace("$threadNo", "0");
                        browserExeCmd = browserExeCmd + " http://sahi.example.com/_s_/dyn/Driver_initialized";
                        browserExeCmd = Utils.expandSystemProperties(browserExeCmd);
                        System.out.println(browserExeCmd);
                        Dashboard.this.execCommand(browserExeCmd);
                        if (browserType.useSystemProxy()) {
                            ProxySwitcher.revertSystemProxy();
                        }
                    }
                }.start();
            }
        });
        panel.add(button);
        this.pack();
    }

    private void execCommand(String cmd) {
        try {
            Utils.executeCommand(Utils.getCommandTokens(cmd));
        }
        catch (Exception ex) {
            Logger.getLogger(Dashboard.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void stopProxy() {
        this.currentInstance.stop();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Configuration.init(args[0], args[1]);
        } else {
            Configuration.init();
        }
        new Dashboard();
    }
}

