/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.ui;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.sahi.util.Utils;

public class LinkButton
extends JLabel {
    private static final long serialVersionUID = 8273875024682878518L;

    public LinkButton(final String text, final String uri) {
        this.setText(text);
        this.setToolTipText(uri.toString());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LinkButton.open(uri);
            }

            public void mouseEntered(MouseEvent e) {
                LinkButton.this.setCursor(new Cursor(12));
                LinkButton.this.setText(text, true);
            }

            public void mouseExited(MouseEvent e) {
                LinkButton.this.setCursor(new Cursor(0));
                LinkButton.this.setText(text, false);
            }
        });
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public void setText(String text, boolean highlight) {
        text = "<u>" + text + "</u>";
        super.setText("<html><span style=\"color: " + (highlight ? "#FF0000" : "#000099;") + "\">" + text + "</span></html>");
    }

    private static void open(String url) {
        String osName = System.getProperty("os.name");
        String cmd = null;
        cmd = osName.startsWith("Mac OS") ? "open " : (osName.startsWith("Windows") ? "cmd.exe /C start " : "xdg-open ");
        cmd = cmd + url.toString();
        try {
            Utils.executeAndGetProcess(Utils.getCommandTokens(cmd));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Please navigate to http://localost:9999/_s_/ControllerUI to configure browsers for Sahi", "Cannot Launch Link", 2);
        }
    }
}

