/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.util;

import net.sf.sahi.util.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BrowserType {
    private final String name;
    private final String path;
    private final String options;
    private final String processName;
    private final int capacity;
    private final String displayName;
    private final String icon;
    private boolean useSystemProxy;

    BrowserType(String browserName, String browserPath, String browserOptions, String browserProcessToKill, int capacity, String displayName, String icon, boolean useSystemProxy) {
        this.name = browserName;
        this.path = browserPath;
        this.options = browserOptions;
        this.processName = browserProcessToKill;
        this.capacity = capacity;
        this.displayName = displayName;
        this.icon = icon;
        this.useSystemProxy = useSystemProxy;
    }

    public String name() {
        return this.name;
    }

    public String path() {
        return this.path;
    }

    public String options() {
        return this.options;
    }

    public String processName() {
        return this.processName;
    }

    public int capacity() {
        return this.capacity;
    }

    public String displayName() {
        return Utils.isBlankOrNull(this.displayName) ? this.name : this.displayName;
    }

    public String icon() {
        return this.icon;
    }

    public static BrowserType load(Element xmlEl) {
        String name = BrowserType.getTextFromXMLNode("name", xmlEl);
        String path = BrowserType.getTextFromXMLNode("path", xmlEl);
        String options = BrowserType.getTextFromXMLNode("options", xmlEl);
        String processName = BrowserType.getTextFromXMLNode("processName", xmlEl);
        int capacity1 = 1;
        try {
            capacity1 = Integer.parseInt(BrowserType.getTextFromXMLNode("capacity", xmlEl));
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((path.contains("firefox") || processName.contains("firefox")) && !options.contains("\"")) {
            options = options.replace("-profile ", "-profile \"").replace("$threadNo", "$threadNo\"");
        }
        return new BrowserType(name, path, options, processName, capacity1, BrowserType.getTextFromXMLNode("displayName", xmlEl), BrowserType.getTextFromXMLNode("icon", xmlEl), "true".equals(BrowserType.getTextFromXMLNode("useSystemProxy", xmlEl)));
    }

    private static String getTextFromXMLNode(String name, Element xmlEl) {
        NodeList byTagName = xmlEl.getElementsByTagName(name);
        if (byTagName.getLength() == 0) {
            return null;
        }
        try {
            return byTagName.item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean useSystemProxy() {
        return this.useSystemProxy;
    }
}

