/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.util.FileUtils;
import net.sf.sahi.util.ThreadLocalMap;

public class TrafficLogger {
    static String trafficDir;
    private String reqFileName;
    private File threadDir;
    private final String type;
    private final boolean log;
    private final Date time;

    public TrafficLogger(String reqFileName, String type, boolean log, Date time) {
        this.type = type;
        this.log = log;
        this.time = time;
        if (log) {
            this.init(reqFileName);
        }
    }

    private void init(String reqFileName) {
        this.reqFileName = FileUtils.cleanFileName(reqFileName);
        this.threadDir = this.getThreadDir();
    }

    protected synchronized String createThreadId() {
        return new SimpleDateFormat("HH_mm_ss_SSS").format(this.time);
    }

    private void storeRequestHeader(byte[] bytes) {
        this.store(bytes, "request.header_" + this.type + ".txt");
    }

    private void storeRequestBody(byte[] bytes) {
        this.store(bytes, "request.body_" + this.type + ".txt");
    }

    private void storeResponseHeader(byte[] bytes) {
        this.store(bytes, "response.header_" + this.type + ".txt");
    }

    private void storeResponseBody(byte[] bytes) {
        this.store(bytes, "response.body_" + this.type + (this.reqFileName == null ? "" : "_" + this.reqFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(byte[] bytes, String fileName) {
        if (!this.log) {
            return;
        }
        if (bytes == null) {
            return;
        }
        File file = new File(this.threadDir, fileName);
        FileOutputStream out = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file, true);
            out.write(bytes);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getThreadDir() {
        String threadId = this.createThreadId();
        File threadDir = new File(trafficDir + "/" + new SimpleDateFormat("yyyy_MM_dd").format(this.time) + "/" + threadId + (this.reqFileName == null ? "" : "_" + this.reqFileName));
        threadDir.mkdirs();
        return threadDir;
    }

    public static TrafficLogger getLoggerForThread(String type) {
        return (TrafficLogger)ThreadLocalMap.get("logger_" + type);
    }

    public static void createLoggerForThread(String fileName, String type, boolean log, Date time) {
        TrafficLogger logger = new TrafficLogger(fileName, type, log, time);
        ThreadLocalMap.put("logger_" + type, logger);
    }

    public static void storeRequestHeader(byte[] bytes, String type) {
        TrafficLogger loggerForThread = TrafficLogger.getLoggerForThread(type);
        if (loggerForThread != null) {
            loggerForThread.storeRequestHeader(bytes);
        }
    }

    public static void storeRequestBody(byte[] bytes, String type) {
        TrafficLogger loggerForThread = TrafficLogger.getLoggerForThread(type);
        if (loggerForThread != null) {
            loggerForThread.storeRequestBody(bytes);
        }
    }

    public static void storeResponseHeader(byte[] bytes, String type) {
        TrafficLogger loggerForThread = TrafficLogger.getLoggerForThread(type);
        if (loggerForThread != null) {
            loggerForThread.storeResponseHeader(bytes);
        }
    }

    public static void storeResponseBody(byte[] bytes, String type) {
        TrafficLogger loggerForThread = TrafficLogger.getLoggerForThread(type);
        if (loggerForThread != null) {
            loggerForThread.storeResponseBody(bytes);
        }
    }

    static {
        String logsRoot = Configuration.getLogsRoot();
        trafficDir = logsRoot + "/traffic";
    }
}

