/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;

public abstract class ExtensionFunctionDefinition {
    public abstract StructuredQName getFunctionQName();

    public int getMinimumNumberOfArguments() {
        return this.getArgumentTypes().length;
    }

    public int getMaximumNumberOfArguments() {
        return this.getMinimumNumberOfArguments();
    }

    public abstract SequenceType[] getArgumentTypes();

    public abstract SequenceType getResultType(SequenceType[] var1);

    public boolean trustResultType() {
        return false;
    }

    public boolean dependsOnFocus() {
        return false;
    }

    public boolean hasSideEffects() {
        return false;
    }

    public abstract ExtensionFunctionCall makeCallExpression();

    public final Function asFunction() {
        return new ExtensionFunction(this);
    }

    private static class ExtensionFunction
    extends AbstractFunction {
        private final ExtensionFunctionDefinition definition;

        public ExtensionFunction(ExtensionFunctionDefinition definition) {
            this.definition = definition;
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
            return this.definition.makeCallExpression().call(context, args);
        }

        @Override
        public FunctionItemType getFunctionItemType() {
            return new SpecificFunctionType(this.definition.getArgumentTypes(), this.definition.getResultType(this.definition.getArgumentTypes()));
        }

        @Override
        public StructuredQName getFunctionName() {
            return this.definition.getFunctionQName();
        }

        @Override
        public int getArity() {
            return this.definition.getArgumentTypes().length;
        }

        @Override
        public String getDescription() {
            return this.definition.getFunctionQName().getDisplayName();
        }

        @Override
        public boolean isTrustedResultType() {
            return this.definition.trustResultType();
        }
    }
}

