/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.LocalVariableEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.StandardDiagnostics;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AlphaCode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class SuppliedParameterReference
extends Expression {
    private final int slotNumber;
    private SequenceType type;

    public SuppliedParameterReference(int slot) {
        this.slotNumber = slot;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSuppliedType(SequenceType type) {
        this.type = type;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    @Override
    public ItemType getItemType() {
        if (this.type != null) {
            return this.type.getPrimaryType();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public int getIntrinsicDependencies() {
        return 128;
    }

    @Override
    protected int computeCardinality() {
        if (this.type != null) {
            return this.type.getCardinality();
        }
        return 57344;
    }

    @Override
    public boolean supportsLazyEvaluation() {
        return false;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        SuppliedParameterReference exp = new SuppliedParameterReference(this.slotNumber);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getImplementationMethod() {
        return 3;
    }

    public Sequence evaluateVariable(XPathContext c) {
        if (this.slotNumber == -1) {
            return c.getStackFrame().popDynamicValue();
        }
        try {
            return c.evaluateLocalVariable(this.slotNumber);
        }
        catch (AssertionError e) {
            new StandardDiagnostics().logStackTrace(c, c.getConfiguration().getLogger(), 2);
            throw new AssertionError((Object)(((Throwable)((Object)e)).getMessage() + ". No value has been set for parameter " + this.slotNumber));
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.evaluateVariable(context).iterate();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.evaluateVariable(context).head();
    }

    @Override
    public String getExpressionName() {
        return "supplied";
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("supplied", this);
        destination.emitAttribute("slot", "" + this.slotNumber);
        if (this.type != null) {
            destination.emitAttribute("sType", AlphaCode.fromSequenceType(this.type));
        }
        destination.endElement();
    }

    @Override
    public String toString() {
        return "suppliedParam(" + this.slotNumber + ")";
    }

    @Override
    public Elaborator getElaborator() {
        return new SuppliedParameterReferenceElaborator();
    }

    public static class SuppliedParameterReferenceElaborator
    extends PullElaborator {
        @Override
        public SequenceEvaluator eagerly() {
            SuppliedParameterReference varRef = (SuppliedParameterReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return new LocalVariableEvaluator(slot);
        }

        @Override
        public SequenceEvaluator lazily(boolean repeatable, boolean lazyEvaluationRequired) {
            return this.eagerly();
        }

        @Override
        public PullEvaluator elaborateForPull() {
            SuppliedParameterReference varRef = (SuppliedParameterReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return context -> context.evaluateLocalVariable(slot).iterate();
        }

        @Override
        public PushEvaluator elaborateForPush() {
            SuppliedParameterReference varRef = (SuppliedParameterReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return (out, context) -> {
                Item it;
                SequenceIterator value = context.evaluateLocalVariable(slot).iterate();
                while ((it = value.next()) != null) {
                    out.append(it);
                }
                return null;
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            SuppliedParameterReference varRef = (SuppliedParameterReference)this.getExpression();
            int slot = varRef.getSlotNumber();
            return context -> context.evaluateLocalVariable(slot).head();
        }
    }
}

