/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.value.Whitespace;

public final class Tokenizer {
    public static final char FULL_WIDTH_LT = '\uff1c';
    public static final char FULL_WIDTH_GT = '\uff1e';
    public static final char NUL = '\u0000';
    private int state = 0;
    public static final int DEFAULT_STATE = 0;
    public static final int BARE_NAME_STATE = 1;
    public static final int SEQUENCE_TYPE_STATE = 2;
    public static final int OPERATOR_STATE = 3;
    public int currentToken = 0;
    public String currentTokenValue = null;
    public int currentTokenStartOffset = 0;
    private int nextToken = 0;
    private String nextTokenValue = null;
    private int nextTokenStartOffset = 0;
    public String input;
    public int inputOffset = 0;
    private int inputLength;
    private int lineNumber = 1;
    private int nextLineNumber = 1;
    private List<Integer> newlineOffsets = null;
    private int precedingToken = -1;
    private String precedingTokenValue = "";
    public boolean disallowUnionKeyword;
    public boolean isXQuery = false;
    public int languageLevel = 20;
    public boolean allowSaxonExtensions = false;

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 0) {
            this.precedingToken = -1;
            this.precedingTokenValue = "";
            this.currentToken = -1;
        } else if (state == 3) {
            this.precedingToken = 204;
            this.precedingTokenValue = ")";
            this.currentToken = 204;
        }
    }

    public void tokenize(String input, int start, int end) throws XPathException {
        this.nextToken = 0;
        this.nextTokenValue = null;
        this.nextTokenStartOffset = 0;
        this.inputOffset = start;
        this.input = input;
        this.lineNumber = 0;
        this.nextLineNumber = 0;
        this.inputLength = end == -1 ? input.length() : end;
        this.lookAhead();
        this.next();
    }

    public void next() throws XPathException {
        this.precedingToken = this.currentToken;
        this.precedingTokenValue = this.currentTokenValue;
        this.currentToken = this.nextToken;
        this.currentTokenValue = this.nextTokenValue;
        if (this.currentTokenValue == null) {
            this.currentTokenValue = "";
        }
        this.currentTokenStartOffset = this.nextTokenStartOffset;
        this.lineNumber = this.nextLineNumber;
        switch (this.currentToken) {
            case 201: {
                int optype = this.getBinaryOp(this.currentTokenValue);
                if (optype == -1 || this.followsOperator(this.precedingToken)) break;
                this.currentToken = optype;
                break;
            }
            case 12: {
                if (!this.isXQuery || !this.followsOperator(this.precedingToken) || this.currentTokenValue.equals("\uff1c")) break;
                this.currentToken = 217;
                break;
            }
            case 207: {
                if (this.followsOperator(this.precedingToken)) break;
                this.currentToken = 17;
            }
        }
        if (this.currentToken == 217 || this.currentToken == 215 || this.currentToken == 223) {
            return;
        }
        int oldPrecedingToken = this.precedingToken;
        this.lookAhead();
        if (this.currentToken == 201) {
            if (this.state == 1) {
                return;
            }
            if (oldPrecedingToken == 21) {
                return;
            }
            this.handleNextToken(oldPrecedingToken);
        }
    }

    public boolean thereMightBeAnArrowAhead() {
        return this.input.indexOf("->", this.currentTokenStartOffset) >= 0 || this.input.indexOf("-\uff1e", this.currentTokenStartOffset) >= 0;
    }

    private void handleNextToken(int oldPrecedingToken) throws XPathException {
        switch (this.nextToken) {
            case 5: {
                this.handleLPAR(oldPrecedingToken);
                break;
            }
            case 59: {
                this.handleLCURLY();
                break;
            }
            case 41: {
                this.handleCOLONCOLON();
                break;
            }
            case 44: {
                this.handleHASH();
                break;
            }
            case 42: {
                this.handleCOLONSTAR();
                break;
            }
            case 21: {
                this.handleDOLLAR();
                break;
            }
            case 116: {
                this.handlePERCENT();
                break;
            }
            case 201: {
                String composite;
                int possibleToken;
                int candidate = this.getCandidate();
                if (candidate != -1) {
                    String qname = this.nextTokenValue;
                    String saveTokenValue = this.currentTokenValue;
                    int savePosition = this.inputOffset;
                    this.lookAhead();
                    if (this.nextToken == 59) {
                        this.currentToken = candidate;
                        this.currentTokenValue = qname;
                        this.lookAhead();
                        return;
                    }
                    this.currentToken = 201;
                    this.currentTokenValue = saveTokenValue;
                    this.inputOffset = savePosition;
                    this.nextToken = 201;
                    this.nextTokenValue = qname;
                }
                if ((possibleToken = Token.doubleKeywords.getOrDefault(composite = this.currentTokenValue + " " + this.nextTokenValue, -1).intValue()) == -1) break;
                this.handleNotUnknown(composite, possibleToken);
                return;
            }
        }
    }

    private void handleLPAR(int oldPrecedingToken) throws XPathException {
        int op = this.getBinaryOp(this.currentTokenValue);
        if (op == -1 || this.followsOperator(oldPrecedingToken)) {
            this.currentToken = this.getFunctionType(this.currentTokenValue);
            this.lookAhead();
        } else {
            this.currentToken = op;
        }
    }

    private void handleLCURLY() throws XPathException {
        if (this.state != 2) {
            this.currentToken = 60;
            this.lookAhead();
        }
    }

    private void handleCOLONCOLON() throws XPathException {
        this.lookAhead();
        this.currentToken = 36;
    }

    private void handleHASH() throws XPathException {
        this.lookAhead();
        this.currentToken = 43;
    }

    private void handleCOLONSTAR() throws XPathException {
        this.lookAhead();
        this.currentToken = 208;
    }

    private void handleDOLLAR() throws XPathException {
        switch (this.currentTokenValue) {
            case "for": {
                this.currentToken = 211;
                break;
            }
            case "some": {
                this.currentToken = 32;
                break;
            }
            case "every": {
                this.currentToken = 33;
                break;
            }
            case "let": {
                this.currentToken = 216;
                break;
            }
            case "count": {
                this.currentToken = 220;
                break;
            }
            case "copy": {
                this.currentToken = 219;
            }
        }
    }

    private void handlePERCENT() throws XPathException {
        if (this.currentTokenValue.equals("declare")) {
            this.currentToken = 140;
        }
    }

    private int getCandidate() {
        int candidate = -1;
        switch (this.currentTokenValue) {
            case "element": {
                candidate = 61;
                break;
            }
            case "attribute": {
                candidate = 62;
                break;
            }
            case "processing-instruction": {
                candidate = 63;
                break;
            }
            case "namespace": {
                candidate = 64;
            }
        }
        return candidate;
    }

    private void handleNotUnknown(String composite, int possibleToken) throws XPathException {
        this.currentToken = possibleToken;
        this.currentTokenValue = composite;
        if (this.currentToken == 128) {
            this.lookAhead();
            if (this.nextToken != 201 || !this.nextTokenValue.equals("of")) {
                throw new XPathException("After '" + composite + "', expected 'of'");
            }
            this.lookAhead();
            if (this.nextToken != 201 || !this.nextTokenValue.equals("node")) {
                throw new XPathException("After 'replace value of', expected 'node'");
            }
            this.nextToken = this.currentToken;
        }
        this.lookAhead();
    }

    int peekAhead() {
        return this.nextToken;
    }

    public void treatCurrentAsOperator() {
        switch (this.currentToken) {
            case 201: {
                int optype = this.getBinaryOp(this.currentTokenValue);
                if (optype == -1) break;
                this.currentToken = optype;
                break;
            }
            case 207: {
                this.currentToken = 17;
            }
        }
    }

    public void lookAhead() throws XPathException {
        char c;
        this.precedingToken = this.nextToken;
        this.precedingTokenValue = this.nextTokenValue;
        this.nextTokenValue = null;
        this.nextTokenStartOffset = this.inputOffset;
        block48: while (true) {
            if (this.inputOffset >= this.inputLength) {
                this.nextToken = 0;
                return;
            }
            c = this.input.charAt(this.inputOffset++);
            switch (c) {
                case '/': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '/') {
                        ++this.inputOffset;
                        this.nextToken = 8;
                        return;
                    }
                    this.nextToken = 2;
                    return;
                }
                case ':': {
                    if (this.inputOffset < this.inputLength) {
                        if (this.input.charAt(this.inputOffset) == ':') {
                            ++this.inputOffset;
                            this.nextToken = 41;
                            return;
                        }
                        if (this.input.charAt(this.inputOffset) == '=') {
                            this.nextToken = 58;
                            ++this.inputOffset;
                            return;
                        }
                        this.nextToken = 76;
                        return;
                    }
                    throw new XPathException("Unexpected colon at start of token");
                }
                case '@': {
                    this.nextToken = 3;
                    return;
                }
                case '?': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '?') {
                        ++this.inputOffset;
                        this.nextToken = 48;
                        return;
                    }
                    this.nextToken = 213;
                    return;
                }
                case '[': {
                    this.nextToken = 4;
                    return;
                }
                case ']': {
                    this.nextToken = 203;
                    return;
                }
                case '{': {
                    this.nextToken = 59;
                    return;
                }
                case '}': {
                    this.nextToken = 215;
                    return;
                }
                case ';': {
                    this.nextToken = 149;
                    this.state = 0;
                    return;
                }
                case '%': {
                    this.nextToken = 116;
                    return;
                }
                case '(': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '#') {
                        ++this.inputOffset;
                        int pragmaStart = this.inputOffset;
                        int nestingDepth = 1;
                        while (nestingDepth > 0 && this.inputOffset < this.inputLength - 1) {
                            if (this.input.charAt(this.inputOffset) == '\n') {
                                this.incrementLineNumber();
                            } else if (this.input.charAt(this.inputOffset) == '#' && this.input.charAt(this.inputOffset + 1) == ')') {
                                --nestingDepth;
                                ++this.inputOffset;
                            } else if (this.input.charAt(this.inputOffset) == '(' && this.input.charAt(this.inputOffset + 1) == '#') {
                                ++nestingDepth;
                                ++this.inputOffset;
                            }
                            ++this.inputOffset;
                        }
                        if (nestingDepth > 0) {
                            throw new XPathException("Unclosed XQuery pragma");
                        }
                        this.nextToken = 218;
                        this.nextTokenValue = this.input.substring(pragmaStart, this.inputOffset - 2);
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == ':') {
                        ++this.inputOffset;
                        int nestingDepth = 1;
                        while (nestingDepth > 0 && this.inputOffset < this.inputLength - 1) {
                            if (this.input.charAt(this.inputOffset) == '\n') {
                                this.incrementLineNumber();
                            } else if (this.input.charAt(this.inputOffset) == ':' && this.input.charAt(this.inputOffset + 1) == ')') {
                                --nestingDepth;
                                ++this.inputOffset;
                            } else if (this.input.charAt(this.inputOffset) == '(' && this.input.charAt(this.inputOffset + 1) == ':') {
                                ++nestingDepth;
                                ++this.inputOffset;
                            }
                            ++this.inputOffset;
                        }
                        if (nestingDepth > 0) {
                            throw new XPathException("Unclosed XPath comment");
                        }
                        this.lookAhead();
                    } else {
                        this.nextToken = 5;
                    }
                    return;
                }
                case ')': {
                    this.nextToken = 204;
                    return;
                }
                case '+': {
                    this.nextToken = 15;
                    return;
                }
                case '-': {
                    if (this.inputOffset < this.inputLength && this.isGreaterThanChar(this.input.charAt(this.inputOffset))) {
                        ++this.inputOffset;
                        this.nextToken = 83;
                        return;
                    }
                    this.nextToken = 16;
                    return;
                }
                case '=': {
                    if (this.inputOffset < this.inputLength && this.isGreaterThanChar(this.input.charAt(this.inputOffset))) {
                        ++this.inputOffset;
                        this.nextToken = 77;
                        return;
                    }
                    if (this.inputOffset < this.inputLength - 1 && this.input.charAt(this.inputOffset) == '!' && this.isGreaterThanChar(this.input.charAt(this.inputOffset + 1))) {
                        this.inputOffset += 2;
                        this.nextToken = 86;
                        return;
                    }
                    this.nextToken = 6;
                    return;
                }
                case '!': {
                    if (this.inputOffset < this.inputLength) {
                        if (this.input.charAt(this.inputOffset) == '=') {
                            ++this.inputOffset;
                            this.nextToken = 22;
                            return;
                        }
                        if (this.input.charAt(this.inputOffset) == '!') {
                            ++this.inputOffset;
                            this.nextToken = 49;
                            return;
                        }
                    }
                    this.nextToken = 40;
                    return;
                }
                case '*': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == ':' && this.inputOffset + 1 < this.inputLength && (this.input.charAt(this.inputOffset + 1) > '\u007f' || NameChecker.isNCNameStartChar(this.input.charAt(this.inputOffset + 1)))) {
                        ++this.inputOffset;
                        this.nextToken = 70;
                        return;
                    }
                    this.nextToken = 207;
                    return;
                }
                case '\u00d7': {
                    if (this.languageLevel >= 40) {
                        this.nextToken = 84;
                        return;
                    }
                    throw new XPathException("Multiply operator '\u00d7' is recognized only when XPath 4.0 is enabled");
                }
                case '\u00f7': {
                    if (this.languageLevel >= 40) {
                        this.nextToken = 85;
                        return;
                    }
                    throw new XPathException("Divide operator '\u00f7' is recognized only when XPath 4.0 is enabled");
                }
                case ',': {
                    this.nextToken = 7;
                    return;
                }
                case '$': {
                    this.nextToken = 21;
                    return;
                }
                case '<': 
                case '\uff1c': {
                    if (c == '\uff1c' && this.languageLevel < 40) {
                        throw new XPathException("Operator character FULL_WIDTH_LESS_THAN (xFF1C) requires XPath 4.0 to be enabled");
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 14;
                        return;
                    }
                    if (this.inputOffset < this.inputLength && c == this.input.charAt(this.inputOffset)) {
                        ++this.inputOffset;
                        this.nextToken = 38;
                        return;
                    }
                    this.nextToken = 12;
                    this.nextTokenValue = "" + c;
                    return;
                }
                case '|': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '|') {
                        ++this.inputOffset;
                        this.nextToken = 30;
                        return;
                    }
                    this.nextToken = 1;
                    return;
                }
                case '#': {
                    this.nextToken = 44;
                    return;
                }
                case '>': 
                case '\uff1e': {
                    if (c == '\uff1e' && this.languageLevel < 40) {
                        throw new XPathException("Operator character FULL_WIDTH_GREATER_THAN (xFF1E) requires XPath 4.0 to be enabled");
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 13;
                        return;
                    }
                    if (this.inputOffset < this.inputLength && c == this.input.charAt(this.inputOffset)) {
                        ++this.inputOffset;
                        this.nextToken = 39;
                        return;
                    }
                    this.nextToken = 11;
                    return;
                }
                case '.': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '.') {
                        ++this.inputOffset;
                        this.nextToken = 206;
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '{') {
                        ++this.inputOffset;
                        this.nextTokenValue = ".";
                        this.nextToken = 60;
                        return;
                    }
                    if (this.inputOffset == this.inputLength || this.input.charAt(this.inputOffset) < '0' || this.input.charAt(this.inputOffset) > '9') {
                        this.nextToken = 205;
                        return;
                    }
                    CSharp.emitCode("goto case '0';");
                }
                case '0': {
                    if (this.inputOffset < this.inputLength && this.languageLevel >= 40) {
                        if (this.input.charAt(this.inputOffset) == 'x') {
                            ++this.inputOffset;
                            while (this.inputOffset < this.inputLength && "0123456789abcdefABCDEF_".indexOf(this.input.charAt(this.inputOffset)) >= 0) {
                                ++this.inputOffset;
                            }
                            String body = this.input.substring(this.nextTokenStartOffset + 2, this.inputOffset);
                            if (body.startsWith("_") || body.endsWith("_")) {
                                throw new XPathException("Underscore not allowed at start or end of hex literal");
                            }
                            this.nextTokenValue = body.replace("_", "");
                            this.nextToken = 224;
                            return;
                        }
                        if (this.input.charAt(this.inputOffset) == 'b') {
                            ++this.inputOffset;
                            while (this.inputOffset < this.inputLength && "01_".indexOf(this.input.charAt(this.inputOffset)) >= 0) {
                                ++this.inputOffset;
                            }
                            String body = this.input.substring(this.nextTokenStartOffset + 2, this.inputOffset);
                            if (body.startsWith("_") || body.endsWith("_")) {
                                throw new XPathException("Underscore not allowed at start or end of binary literal");
                            }
                            this.nextTokenValue = body.replace("_", "");
                            this.nextToken = 225;
                            return;
                        }
                    }
                    CSharp.emitCode("goto case '1';");
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean allowE = true;
                    boolean allowSign = false;
                    boolean allowDot = true;
                    boolean keepGoing = true;
                    boolean allowUnderscore = this.languageLevel >= 40;
                    while (true) {
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                allowSign = false;
                                break;
                            }
                            case '.': {
                                if (allowDot) {
                                    allowDot = false;
                                    allowSign = false;
                                    break;
                                }
                                --this.inputOffset;
                                keepGoing = false;
                                break;
                            }
                            case '_': {
                                if (allowUnderscore) {
                                    if (this.inputOffset >= this.inputLength || "0123456789_".indexOf(this.input.charAt(this.inputOffset)) < 0) {
                                        throw new XPathException("Underscore must be followed by a digit (or another underscore)");
                                    }
                                    if (this.inputOffset >= 2 && "0123456789_".indexOf(this.input.charAt(this.inputOffset - 2)) >= 0) break;
                                    throw new XPathException("Underscore must be preceded by a digit (or another underscore)");
                                }
                                throw new XPathException("Underscore is not allowed in numeric literal unless 4.0 is enabled");
                            }
                            case 'E': 
                            case 'e': {
                                if (allowE) {
                                    allowSign = true;
                                    allowE = false;
                                    break;
                                }
                                --this.inputOffset;
                                keepGoing = false;
                                break;
                            }
                            case '+': 
                            case '-': {
                                if (allowSign) {
                                    allowSign = false;
                                    break;
                                }
                                --this.inputOffset;
                                keepGoing = false;
                                break;
                            }
                            default: {
                                if ('a' <= c && c <= 'z' || c > '\u007f') {
                                    throw new XPathException("Separator needed after numeric literal");
                                }
                                --this.inputOffset;
                                keepGoing = false;
                            }
                        }
                        if (!keepGoing || this.inputOffset >= this.inputLength) break;
                        c = this.input.charAt(this.inputOffset++);
                    }
                    this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).replace("_", "");
                    this.nextToken = 209;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.nextTokenValue = "";
                    while (true) {
                        char n;
                        this.inputOffset = this.input.indexOf(c, this.inputOffset);
                        if (this.inputOffset < 0) {
                            this.inputOffset = this.nextTokenStartOffset + 1;
                            throw new XPathException("Unmatched quote in expression");
                        }
                        this.nextTokenValue = this.nextTokenValue + this.input.substring(this.nextTokenStartOffset + 1, this.inputOffset++);
                        if (this.inputOffset >= this.inputLength || (n = this.input.charAt(this.inputOffset)) != c) break;
                        this.nextTokenValue = this.nextTokenValue + c;
                        this.nextTokenStartOffset = this.inputOffset++;
                    }
                    if (this.nextTokenValue.indexOf(10) >= 0) {
                        for (int i = 0; i < this.nextTokenValue.length(); ++i) {
                            if (this.nextTokenValue.charAt(i) != '\n') continue;
                            this.incrementLineNumber(this.nextTokenStartOffset + i + 1);
                        }
                    }
                    this.nextToken = 202;
                    return;
                }
                case '`': {
                    if (this.inputOffset < this.inputLength - 1 && this.input.charAt(this.inputOffset) == '`' && this.input.charAt(this.inputOffset + 1) == '[') {
                        if (!this.isXQuery) {
                            throw new XPathException("String constructors (starting '``[') are allowed only in XQuery, not XPath");
                        }
                        this.inputOffset += 2;
                        int j = this.inputOffset;
                        int newlines = 0;
                        while (true) {
                            if (j >= this.inputLength) {
                                throw new XPathException("Unclosed string template in expression");
                            }
                            if (this.input.charAt(j) == '\n') {
                                ++newlines;
                            } else {
                                if (this.input.charAt(j) == '`' && j + 1 < this.inputLength && this.input.charAt(j + 1) == '{') {
                                    this.nextToken = 78;
                                    this.nextTokenValue = this.input.substring(this.inputOffset, j);
                                    this.inputOffset = j + 2;
                                    this.incrementLineNumber(newlines);
                                    return;
                                }
                                if (this.input.charAt(j) == ']' && j + 2 < this.inputLength && this.input.charAt(j + 1) == '`' && this.input.charAt(j + 2) == '`') {
                                    this.nextToken = 222;
                                    this.nextTokenValue = this.input.substring(this.inputOffset, j);
                                    this.inputOffset = j + 3;
                                    this.incrementLineNumber(newlines);
                                    return;
                                }
                            }
                            ++j;
                        }
                    }
                    this.nextToken = 223;
                    return;
                }
                case '\n': {
                    this.incrementLineNumber();
                    CSharp.emitCode("goto case ' ';");
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    this.nextTokenStartOffset = this.inputOffset;
                    continue block48;
                }
                case 'Q': 
                case '\u00b6': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '{') {
                        int close;
                        if ((close = this.input.indexOf(125, this.inputOffset++)) < this.inputOffset) {
                            throw new XPathException("Missing closing brace in EQName");
                        }
                        String uri = this.input.substring(this.inputOffset, close);
                        if ((uri = Whitespace.collapseWhitespace(uri)).contains("{")) {
                            throw new XPathException("EQName must not contain opening brace");
                        }
                        int start = this.inputOffset = close + 1;
                        boolean isStar = false;
                        while (this.inputOffset < this.inputLength) {
                            char c2 = this.input.charAt(this.inputOffset);
                            if (c2 > '\u0080' || Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '.' || c2 == '-') {
                                ++this.inputOffset;
                                continue;
                            }
                            if (c2 != '*' || start != this.inputOffset) break;
                            ++this.inputOffset;
                            isStar = true;
                            break;
                        }
                        String localName = this.input.substring(start, this.inputOffset);
                        this.nextTokenValue = "Q{" + uri + "}" + localName;
                        this.nextToken = isStar ? 208 : 201;
                        return;
                    }
                    CSharp.emitCode("goto default;");
                }
                default: {
                    if (c < '\u0080' && !Character.isLetter(c)) {
                        throw new XPathException("Invalid character '" + c + "' (x" + Integer.toHexString(c) + ") in expression");
                    }
                    CSharp.emitCode("goto case '_';");
                }
                case '_': 
            }
            break;
        }
        boolean foundColon = false;
        boolean breakLoop = false;
        while (this.inputOffset < this.inputLength) {
            c = this.input.charAt(this.inputOffset);
            switch (c) {
                case ':': {
                    if (!foundColon) {
                        if (this.precedingToken == 213 || this.precedingToken == 70) {
                            this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset);
                            this.nextToken = 201;
                            return;
                        }
                        if (this.inputOffset + 1 < this.inputLength) {
                            char nc = this.input.charAt(this.inputOffset + 1);
                            if (nc == ':') {
                                this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset);
                                this.nextToken = 36;
                                this.inputOffset += 2;
                                return;
                            }
                            if (nc == '*') {
                                this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset);
                                this.nextToken = 208;
                                this.inputOffset += 2;
                                return;
                            }
                            if (nc != '_' && nc <= '\u007f' && !Character.isLetter(nc)) {
                                this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset);
                                this.nextToken = 201;
                                return;
                            }
                        }
                        foundColon = true;
                        break;
                    }
                    breakLoop = true;
                    break;
                }
                case '-': 
                case '.': {
                    if (this.precedingToken > 150 && this.precedingToken != 213 && this.precedingToken != 70 && this.getBinaryOp(this.input.substring(this.nextTokenStartOffset, this.inputOffset)) != -1 && (this.precedingToken != 201 || this.getBinaryOp(this.precedingTokenValue) == -1)) {
                        this.nextToken = this.getBinaryOp(this.input.substring(this.nextTokenStartOffset, this.inputOffset));
                        return;
                    }
                    CSharp.emitCode("goto case '_';");
                }
                case '_': {
                    break;
                }
                default: {
                    if (c >= '\u0080' || Character.isLetterOrDigit(c)) break;
                    breakLoop = true;
                }
            }
            if (breakLoop) break;
            ++this.inputOffset;
        }
        this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset);
        this.nextToken = 201;
    }

    int getBinaryOp(String s) {
        switch (s) {
            case "after": {
                return 133;
            }
            case "and": {
                return 10;
            }
            case "as": {
                return 71;
            }
            case "before": {
                return 134;
            }
            case "case": {
                return 67;
            }
            case "default": {
                return 212;
            }
            case "div": {
                return 18;
            }
            case "else": {
                return 27;
            }
            case "eq": {
                return 50;
            }
            case "except": {
                return 24;
            }
            case "ge": {
                return 54;
            }
            case "gt": {
                return 52;
            }
            case "idiv": {
                return 56;
            }
            case "in": {
                return 31;
            }
            case "intersect": {
                return 23;
            }
            case "into": {
                return 135;
            }
            case "is": {
                return 20;
            }
            case "le": {
                return 55;
            }
            case "lt": {
                return 53;
            }
            case "mod": {
                return 19;
            }
            case "modify": {
                return 68;
            }
            case "ne": {
                return 51;
            }
            case "or": {
                return 9;
            }
            case "otherwise": {
                return 79;
            }
            case "return": {
                return 25;
            }
            case "satisfies": {
                return 34;
            }
            case "then": {
                return 26;
            }
            case "to": {
                return 29;
            }
            case "union": {
                return 1;
            }
            case "where": {
                return 28;
            }
            case "while": {
                return 82;
            }
            case "with": {
                return 136;
            }
            case "orElse": {
                return this.allowSaxonExtensions ? 81 : -1;
            }
            case "andAlso": {
                return this.allowSaxonExtensions ? 80 : -1;
            }
        }
        return -1;
    }

    private boolean isLessThanChar(char c) {
        return c == '<' || this.languageLevel >= 40 && c == '\uff1c';
    }

    private boolean isGreaterThanChar(char c) {
        return c == '>' || this.languageLevel >= 40 && c == '\uff1e';
    }

    private int getFunctionType(String s) {
        switch (s) {
            case "if": {
                return 37;
            }
            case "namespace-node": 
            case "function": {
                return this.languageLevel == 20 ? 35 : 69;
            }
            case "fn": {
                return this.languageLevel >= 40 ? 69 : 35;
            }
            case "array": 
            case "map": {
                return this.languageLevel == 31 ? 69 : 35;
            }
            case "node": 
            case "schema-attribute": 
            case "schema-element": 
            case "processing-instruction": 
            case "empty-sequence": 
            case "document-node": 
            case "comment": 
            case "element": 
            case "item": 
            case "text": 
            case "attribute": {
                return 69;
            }
            case "atomic": 
            case "tuple": 
            case "record": 
            case "type": 
            case "union": 
            case "enum": {
                return this.allowSaxonExtensions ? 69 : 35;
            }
            case "switch": {
                return this.languageLevel == 20 ? 35 : 66;
            }
            case "otherwise": {
                return 79;
            }
            case "typeswitch": {
                return 65;
            }
        }
        return 35;
    }

    private boolean followsOperator(int precedingToken) {
        return precedingToken <= 150;
    }

    public char nextChar() {
        if (this.inputOffset < this.inputLength) {
            char c;
            if ((c = this.input.charAt(this.inputOffset++)) == '\n') {
                this.incrementLineNumber();
                ++this.lineNumber;
            }
            return c;
        }
        ++this.inputOffset;
        return '\u0000';
    }

    public char peekChar() {
        if (this.inputOffset < this.inputLength) {
            return this.input.charAt(this.inputOffset);
        }
        return '\u0000';
    }

    private void incrementLineNumber() {
        ++this.nextLineNumber;
        if (this.newlineOffsets == null) {
            this.newlineOffsets = new ArrayList<Integer>(20);
        }
        this.newlineOffsets.add(this.inputOffset - 1);
    }

    public void incrementLineNumber(int offset) {
        ++this.nextLineNumber;
        if (this.newlineOffsets == null) {
            this.newlineOffsets = new ArrayList<Integer>(20);
        }
        this.newlineOffsets.add(offset);
    }

    public void unreadChar() {
        if (this.inputOffset > this.inputLength) {
            return;
        }
        if (this.input.charAt(--this.inputOffset) == '\n') {
            --this.nextLineNumber;
            --this.lineNumber;
            if (this.newlineOffsets != null) {
                this.newlineOffsets.remove(this.newlineOffsets.size() - 1);
            }
        }
    }

    String recentText(int offset) {
        if (offset == -1) {
            if (this.inputOffset > this.inputLength) {
                this.inputOffset = this.inputLength;
            }
            if (this.inputOffset < 34) {
                return this.input.substring(0, this.inputOffset);
            }
            return Whitespace.collapseWhitespace("..." + this.input.substring(this.inputOffset - 30, this.inputOffset));
        }
        int end = offset + 30;
        if (end > this.inputLength) {
            end = this.inputLength;
        }
        return Whitespace.collapseWhitespace((offset > 0 ? "..." : "") + this.input.substring(offset, end));
    }

    public void copyTo(Tokenizer u) {
        u.currentToken = this.currentToken;
        u.currentTokenValue = this.currentTokenValue;
        u.precedingToken = this.precedingToken;
        u.precedingTokenValue = this.precedingTokenValue;
        u.nextToken = this.nextToken;
        u.nextTokenValue = this.nextTokenValue;
        u.inputOffset = this.inputOffset;
        u.lineNumber = this.lineNumber;
        u.nextLineNumber = this.nextLineNumber;
        u.newlineOffsets = this.newlineOffsets == null ? null : new ArrayList<Integer>(this.newlineOffsets);
        u.state = this.state;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return (int)(this.getLineAndColumn(this.currentTokenStartOffset) & Integer.MAX_VALUE);
    }

    private long getLineAndColumn(int offset) {
        if (this.newlineOffsets == null) {
            return offset;
        }
        for (int line = this.newlineOffsets.size() - 1; line >= 0; --line) {
            int nloffset = this.newlineOffsets.get(line);
            if (offset <= nloffset) continue;
            return (long)(line + 1) << 32 | (long)(offset - nloffset);
        }
        return offset;
    }

    public int getLineNumber(int offset) {
        return (int)(this.getLineAndColumn(offset) >> 32);
    }

    public int getColumnNumber(int offset) {
        return (int)(this.getLineAndColumn(offset) & Integer.MAX_VALUE);
    }
}

