/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMapper;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.java.CleanerProxy;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.om.DocumentKey;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.str.StringView;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.value.ObjectValue;

public class CollectionFn
extends SystemFunction
implements Callable {
    public static String EMPTY_COLLECTION_URI = "http://saxon.sf.net/collection/empty";
    public static final ResourceCollection EMPTY_COLLECTION = new EmptyCollection(EMPTY_COLLECTION_URI);

    @Override
    public int getSpecialProperties(Expression[] arguments) {
        return super.getSpecialProperties(arguments) & 0xFF7FFFFF | 0x80000;
    }

    public static String getAbsoluteCollectionURI(String baseUri, String href, XPathContext context) throws XPathException {
        String absoluteURI;
        block10: {
            if (href == null) {
                absoluteURI = context.getConfiguration().getDefaultCollection();
            } else {
                URI uri;
                try {
                    uri = new URI(href);
                }
                catch (URISyntaxException e) {
                    href = IriToUri.iriToUri(StringView.tidy(href)).toString();
                    try {
                        uri = new URI(href);
                    }
                    catch (URISyntaxException e2) {
                        throw new XPathException(e2.getMessage(), "FODC0004");
                    }
                }
                try {
                    if (uri.isAbsolute()) {
                        absoluteURI = uri.toString();
                        break block10;
                    }
                    if (baseUri != null) {
                        absoluteURI = ResolveURI.makeAbsolute(href, baseUri).toString();
                        break block10;
                    }
                    throw new XPathException("Relative collection URI cannot be resolved: no base URI available", "FODC0002");
                }
                catch (URISyntaxException e) {
                    throw new XPathException(e.getMessage(), "FODC0004");
                }
            }
        }
        return absoluteURI;
    }

    private SequenceIterator getSequenceIterator(ResourceCollection collection, XPathContext context) throws XPathException {
        Iterator<? extends Resource> sources = collection.getResources(context);
        return new CollectionIterator(sources, context);
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        boolean alreadyStripped;
        CollectionFinder collectionFinder;
        GroundedValue cachedCollection;
        Item arg;
        String href = this.getArity() == 0 ? context.getController().getDefaultCollection() : ((arg = arguments[0].head()) == null ? context.getController().getDefaultCollection() : arg.getStringValue());
        if (href == null) {
            throw new XPathException("No default collection has been defined", "FODC0002");
        }
        String absoluteURI = CollectionFn.getAbsoluteCollectionURI(this.getRetainedStaticContext().getStaticBaseUriString(), href, context);
        PackageData packageData = this.getRetainedStaticContext().getPackageData();
        SpaceStrippingRule whitespaceRule = NoElementsSpaceStrippingRule.getInstance();
        Object collectionKey = absoluteURI;
        if (packageData.isXSLT() && (whitespaceRule = ((StylesheetPackage)packageData).getSpaceStrippingRule()) != NoElementsSpaceStrippingRule.getInstance()) {
            collectionKey = ((StylesheetPackage)packageData).getPackageName() + String.valueOf(((StylesheetPackage)packageData).getPackageVersion()) + " " + absoluteURI;
        }
        if ((cachedCollection = (GroundedValue)context.getController().getUserData("saxon:collections", (String)collectionKey)) != null) {
            return cachedCollection;
        }
        ResourceCollection collection = context.getConfiguration().getRegisteredCollection(absoluteURI);
        if (collection == null && (collectionFinder = context.getController().getCollectionFinder()) != null) {
            collection = collectionFinder.findCollection(context, absoluteURI);
        }
        if (collection == null) {
            collection = new EmptyCollection(EMPTY_COLLECTION_URI);
        }
        if (packageData instanceof StylesheetPackage && whitespaceRule != NoElementsSpaceStrippingRule.getInstance() && collection instanceof AbstractResourceCollection && (alreadyStripped = ((AbstractResourceCollection)collection).stripWhitespace(whitespaceRule))) {
            whitespaceRule = null;
        }
        SequenceIterator sourceSeq = this.getSequenceIterator(collection, context);
        SequenceIterator result = context.getConfiguration().getMultithreadedItemMappingIterator(sourceSeq, ItemMapper.of(it -> ((Resource)((ObjectValue)it).getObject()).getItem()));
        if (whitespaceRule != null) {
            SpaceStrippingRule rule = whitespaceRule;
            result = ItemMappingIterator.map(result, item -> {
                TreeInfo treeInfo;
                if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 9 && (treeInfo = ((NodeInfo)item).getTreeInfo()).getSpaceStrippingRule() != rule) {
                    return new SpaceStrippedDocument(treeInfo, rule).getRootNode();
                }
                return item;
            });
        }
        if (collection.isStable(context) || context.getConfiguration().getBooleanProperty(Feature.STABLE_COLLECTION_URI)) {
            Item item2;
            Controller controller = context.getController();
            DocumentPool docPool = controller.getDocumentPool();
            try {
                cachedCollection = SequenceTool.toGroundedValue(result);
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
            SequenceIterator iter = cachedCollection.iterate();
            while ((item2 = iter.next()) != null) {
                DocumentKey docKey;
                if (!(item2 instanceof NodeInfo) || ((NodeInfo)item2).getNodeKind() != 9) continue;
                String docUri = ((NodeInfo)item2).getSystemId();
                if (packageData instanceof StylesheetPackage) {
                    StylesheetPackage pack = (StylesheetPackage)packageData;
                    docKey = new DocumentKey(docUri, pack.getPackageName(), pack.getPackageVersion());
                } else {
                    docKey = new DocumentKey(docUri);
                }
                if (docPool.find(docKey) != null) continue;
                if (item2 instanceof TreeInfo) {
                    docPool.add((TreeInfo)((Object)item2), docKey);
                    continue;
                }
                docPool.add((TreeInfo)new GenericTreeInfo(controller.getConfiguration(), (NodeInfo)item2), docKey);
            }
            context.getController().setUserData("saxon:collections", (String)collectionKey, cachedCollection);
            return cachedCollection;
        }
        return new LazySequence(result);
    }

    private static class CollectionIterator
    implements SequenceIterator {
        private final Iterator<? extends Resource> sources;
        private CleanerProxy.CleanableProxy cleanable;

        public CollectionIterator(Iterator<? extends Resource> sources, XPathContext context) {
            this.sources = sources;
            if (sources instanceof Closeable) {
                this.cleanable = context.getConfiguration().registerCleanupAction(this, CollectionIterator.getCleaningAction((Closeable)((Object)sources)));
            }
        }

        private static Runnable getCleaningAction(Closeable sources) {
            return () -> {
                try {
                    sources.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            };
        }

        @Override
        public Item next() {
            if (this.sources.hasNext()) {
                return new ObjectValue<Resource>(this.sources.next(), Resource.class);
            }
            return null;
        }

        @Override
        public void close() {
            if (this.cleanable != null) {
                this.cleanable.clean();
            } else if (this.sources instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.sources)).close();
                }
                catch (IOException e) {
                    throw new UncheckedXPathException(new XPathException(e));
                }
            }
        }
    }

    private static class EmptyCollection
    implements ResourceCollection {
        private final String collectionUri;

        EmptyCollection(String cUri) {
            this.collectionUri = cUri;
        }

        @Override
        public String getCollectionURI() {
            return this.collectionUri;
        }

        @Override
        public Iterator<String> getResourceURIs(XPathContext context) {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<? extends Resource> getResources(XPathContext context) {
            return Collections.emptyIterator();
        }

        @Override
        public boolean isStable(XPathContext context) {
            return true;
        }
    }
}

