/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.hof;

import java.util.Arrays;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.ExportAgent;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.functions.registry.FunctionDefinition;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

public class UserFunctionReference
extends Expression
implements ComponentInvocation,
UserFunctionResolvable,
Callable {
    private final SymbolicName.F functionName;
    private UserFunction nominalTarget;
    private int bindingSlot = -1;
    private int optimizeCounter = 0;
    private int typeCheckCounter = 0;

    public UserFunctionReference(UserFunction target) {
        this.nominalTarget = target;
        this.functionName = target.getSymbolicName();
    }

    public UserFunctionReference(UserFunction target, SymbolicName.F name) {
        this.nominalTarget = target;
        this.functionName = name;
    }

    public UserFunctionReference(SymbolicName.F name) {
        this.functionName = name;
    }

    @Override
    public void setFunction(UserFunction function) {
        if (!function.getSymbolicName().getComponentName().equals(this.functionName.getComponentName())) {
            throw new IllegalArgumentException("Function name does not match");
        }
        if (function.getMinimumArity() > this.functionName.getArity() || function.getArity() < this.functionName.getArity()) {
            throw new IllegalArgumentException("Function arity does not match");
        }
        this.nominalTarget = function;
    }

    @Override
    public Expression simplify() throws XPathException {
        if (this.nominalTarget.getFunctionName().hasURI(NamespaceUri.ANONYMOUS) && this.typeCheckCounter == 0) {
            ++this.typeCheckCounter;
            this.nominalTarget.setBody(this.nominalTarget.getBody().simplify());
            --this.typeCheckCounter;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.nominalTarget.getFunctionName().hasURI(NamespaceUri.ANONYMOUS) && this.typeCheckCounter == 0) {
            ++this.typeCheckCounter;
            this.nominalTarget.typeCheck(visitor);
            --this.typeCheckCounter;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.nominalTarget.getFunctionName().hasURI(NamespaceUri.ANONYMOUS) && this.optimizeCounter == 0) {
            ++this.optimizeCounter;
            Expression o = this.nominalTarget.getBody().optimize(visitor, ContextItemStaticInfo.ABSENT);
            this.nominalTarget.setBody(o);
            SlotManager slotManager = visitor.getConfiguration().makeSlotManager();
            for (int i = 0; i < this.getArity(); ++i) {
                UserFunctionParameter param = this.nominalTarget.getParameterDefinitions()[i];
                slotManager.allocateSlotNumber(param.getVariableQName(), param);
            }
            ExpressionTool.allocateSlots(o, this.getArity(), slotManager);
            this.nominalTarget.setStackFrameMap(slotManager);
            --this.optimizeCounter;
        }
        return this;
    }

    @Override
    public int getBindingSlot() {
        return this.bindingSlot;
    }

    @Override
    public Component getFixedTarget() {
        return this.nominalTarget.getDeclaringComponent();
    }

    public UserFunction getNominalTarget() {
        return this.nominalTarget;
    }

    @Override
    public void setBindingSlot(int slot) {
        this.bindingSlot = slot;
    }

    @Override
    public SymbolicName getSymbolicName() {
        return this.functionName;
    }

    public FunctionItemType getFunctionItemType(TypeHierarchy th) {
        return this.nominalTarget.getFunctionItemType();
    }

    public StructuredQName getFunctionName() {
        return this.nominalTarget.getFunctionName();
    }

    public int getArity() {
        return this.functionName.getArity();
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public ItemType getItemType() {
        return this.nominalTarget.getFunctionItemType();
    }

    @Override
    protected int computeSpecialProperties() {
        return 0x10000000;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return UType.FUNCTION;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        UserFunctionReference ref = new UserFunctionReference(this.nominalTarget, this.functionName);
        ref.optimizeCounter = this.optimizeCounter;
        ref.typeCheckCounter = this.typeCheckCounter;
        return ref;
    }

    @Override
    public FunctionItem evaluateItem(XPathContext context) throws XPathException {
        return (FunctionItem)this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public FunctionItem call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evaluateItem(context);
    }

    @Override
    public String getExpressionName() {
        return "UserFunctionReference";
    }

    @Override
    public String toString() {
        return this.getFunctionName().getEQName() + "#" + this.getArity();
    }

    @Override
    public String toShortString() {
        return this.getFunctionName().getDisplayName() + "#" + this.getArity();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        ExpressionPresenter.ExportOptions options = out.getOptions();
        if (this.nominalTarget.getDeclaringComponent() == null) {
            out.startElement("inlineFn");
            this.nominalTarget.export(out);
            out.endElement();
        } else {
            StylesheetPackage rootPackage = options.rootPackage;
            StylesheetPackage containingPackage = this.nominalTarget.getDeclaringComponent().getContainingPackage();
            if (rootPackage != null && rootPackage != containingPackage && !rootPackage.contains(containingPackage)) {
                throw new XPathException("Cannot export a package containing a reference to a user-defined function (" + this.toShortString() + ") that is not present in the package being exported");
            }
            out.startElement("ufRef");
            out.emitAttribute("name", this.nominalTarget.getFunctionName());
            out.emitAttribute("arity", "" + this.nominalTarget.getArity());
            out.emitAttribute("bSlot", "" + this.getBindingSlot());
            out.endElement();
        }
    }

    @Override
    public Elaborator getElaborator() {
        return new UserFunctionReferenceElaborator();
    }

    private static class UserFunctionReferenceElaborator
    extends ItemElaborator {
        private UserFunctionReferenceElaborator() {
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            UserFunctionReference expr = (UserFunctionReference)this.getExpression();
            if (expr.bindingSlot == -1) {
                return context -> new BoundUserFunction(expr.nominalTarget, expr.getArity(), expr.nominalTarget.getDeclaringComponent(), expr, context.getController());
            }
            return context -> {
                Component targetComponent = context.getTargetComponent(expr.bindingSlot);
                return new BoundUserFunction((UserFunction)targetComponent.getActor(), expr.getArity(), targetComponent, expr, context.getController());
            };
        }
    }

    public static class BoundUserFunction
    extends AbstractFunction
    implements ContextOriginator {
        private final ExportAgent agent;
        private final FunctionItem function;
        private final int arity;
        private final Component component;
        private final Controller controller;

        public BoundUserFunction(FunctionItem function, int arity, Component component, ExportAgent agent, Controller controller) {
            this.agent = agent;
            this.function = function;
            this.arity = arity;
            this.component = component;
            this.controller = controller;
        }

        public FunctionItem getTargetFunction() {
            return this.function;
        }

        public Controller getController() {
            return this.controller;
        }

        @Override
        public XPathContext makeNewContext(XPathContext oldContext, ContextOriginator originator) {
            if (this.controller.getConfiguration() != oldContext.getConfiguration()) {
                throw new IllegalStateException("A function created under one Configuration cannot be called under a different Configuration");
            }
            XPathContextMajor c2 = this.controller.newXPathContext();
            c2.setTemporaryOutputState(160);
            c2.setCurrentOutputUri(null);
            c2.setCurrentComponent(this.component);
            c2.setResourceResolver(oldContext.getResourceResolver());
            c2.setOrigin(originator);
            c2.setCaller(oldContext);
            return this.function.makeNewContext(c2, originator);
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
            XPathContext c2 = this.function.makeNewContext(context, this);
            if (c2 instanceof XPathContextMajor && this.component != null) {
                ((XPathContextMajor)c2).setCurrentComponent(this.component);
            }
            if (this.function.getArity() > args.length) {
                assert (this.function instanceof FunctionDefinition && ((FunctionDefinition)((Object)this.function)).getMinimumArity() <= args.length);
                FunctionDefinition fd = (FunctionDefinition)((Object)this.function);
                Sequence[] extendedArgs = Arrays.copyOf(args, fd.getNumberOfParameters());
                for (int i = args.length; i < extendedArgs.length; ++i) {
                    extendedArgs[i] = fd.getDefaultValueExpression(i).copy(new RebindingMap()).makeElaborator().lazily(true, false).evaluate(context);
                }
                args = extendedArgs;
            }
            return this.function.call(c2, args);
        }

        @Override
        public FunctionItemType getFunctionItemType() {
            if (this.function instanceof UserFunction) {
                return ((UserFunction)this.function).getFunctionItemType(this.getArity());
            }
            return this.function.getFunctionItemType();
        }

        @Override
        public AnnotationList getAnnotations() {
            return this.function.getAnnotations();
        }

        @Override
        public StructuredQName getFunctionName() {
            return this.function.getFunctionName();
        }

        @Override
        public int getArity() {
            return this.arity;
        }

        @Override
        public String getDescription() {
            return this.function.getDescription();
        }

        @Override
        public void export(ExpressionPresenter out) throws XPathException {
            this.agent.export(out);
        }
    }
}

