/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeSource;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;

public interface NodeInfo
extends Item,
Location,
ActiveSource {
    public TreeInfo getTreeInfo();

    default public Configuration getConfiguration() {
        return this.getTreeInfo().getConfiguration();
    }

    public int getNodeKind();

    default public boolean isSameNodeInfo(NodeInfo other) {
        return this.equals(other);
    }

    public boolean equals(Object var1);

    public int hashCode();

    @Override
    public String getSystemId();

    @Override
    default public String getPublicId() {
        return null;
    }

    public String getBaseURI();

    @Override
    default public int getLineNumber() {
        return -1;
    }

    @Override
    default public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo var1);

    public boolean hasFingerprint();

    public int getFingerprint();

    public String getLocalPart();

    public NamespaceUri getNamespaceUri();

    default public String getURI() {
        return this.getNamespaceUri().toString();
    }

    public String getDisplayName();

    public String getPrefix();

    default public SchemaType getSchemaType() {
        switch (this.getNodeKind()) {
            case 2: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 1: 
            case 9: {
                return Untyped.getInstance();
            }
        }
        return null;
    }

    @Override
    public AtomicSequence atomize() throws XPathException;

    public NodeInfo getParent();

    default public AxisIterator iterateAxis(int axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(int var1, NodePredicate var2);

    public String getAttributeValue(NamespaceUri var1, String var2);

    default public String getAttributeValue(String uri, String local) {
        return this.getAttributeValue(uri.isEmpty() ? NamespaceUri.NULL : NamespaceUri.of(uri), local);
    }

    public NodeInfo getRoot();

    public boolean hasChildNodes();

    default public Iterable<? extends NodeInfo> children() {
        return new Navigator.ChildrenAsIterable(this);
    }

    default public Iterable<? extends NodeInfo> children(NodePredicate filter) {
        return new Navigator.ChildrenAsIterable(this, filter);
    }

    default public AttributeMap attributes() {
        AttributeMap atts = EmptyAttributeMap.getInstance();
        if (this.getNodeKind() == 1) {
            NodeInfo attr;
            AxisIterator iter = this.iterateAxis(2);
            while ((attr = iter.next()) != null) {
                atts = atts.put(new AttributeInfo(NameOfNode.makeName(attr), (SimpleType)attr.getSchemaType(), attr.getStringValue(), Loc.NONE, 0));
            }
        }
        return atts;
    }

    public void generateId(StringBuilder var1);

    default public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        Navigator.copy(this, out, copyOptions, locationId);
    }

    @Override
    default public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        Sender.sendDocumentInfo(this, receiver, new Loc(this.getSystemId(), -1, -1));
    }

    default public ActiveSource asActiveSource() {
        return new NodeSource(this);
    }

    @Override
    public void setSystemId(String var1);

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] var1);

    public NamespaceMap getAllNamespaces();

    default public boolean isId() {
        return false;
    }

    default public boolean isIdref() {
        return false;
    }

    default public boolean isNilled() {
        return false;
    }

    @Override
    default public boolean isStreamed() {
        return false;
    }

    @Override
    default public String toShortString() {
        switch (this.getNodeKind()) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "<" + this.getDisplayName() + "/>";
            }
            case 2: {
                return "@" + this.getDisplayName();
            }
            case 3: {
                return "text(\"" + String.valueOf(Err.truncate30(this.getUnicodeStringValue())) + "\")";
            }
            case 8: {
                return "<!--" + String.valueOf(Err.truncate30(this.getUnicodeStringValue())) + "-->";
            }
            case 7: {
                return "<?" + this.getDisplayName() + "?>";
            }
            case 13: {
                String prefix = this.getLocalPart();
                return "xmlns" + (String)(prefix.equals("") ? "" : ":" + prefix) + "=\"" + String.valueOf(this.getUnicodeStringValue()) + "\"";
            }
        }
        return "";
    }

    @Override
    default public Genre getGenre() {
        return Genre.NODE;
    }
}

