/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import javax.xml.namespace.QName;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class StructuredQName
implements IdentityComparable {
    private final String prefix;
    private final NamespaceUri uri;
    private final String local;
    private int cachedHashCode = -1;

    public StructuredQName(String prefix, NamespaceUri uri, String localName) {
        this.prefix = prefix == null ? "" : prefix;
        this.uri = uri;
        this.local = localName;
    }

    public StructuredQName(String prefix, String uri, String localName) {
        this.prefix = prefix == null ? "" : prefix;
        this.uri = NamespaceUri.of(uri);
        this.local = localName;
    }

    public static StructuredQName fromClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.startsWith("Q{")) {
            expandedName = expandedName.substring(1);
        }
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return new StructuredQName("", NamespaceUri.of(namespace), localName);
    }

    public static StructuredQName fromLexicalQName(String lexicalName, boolean useDefault, boolean allowEQName, NamespaceResolver resolver) throws XPathException {
        lexicalName = Whitespace.trim(lexicalName);
        if (allowEQName && lexicalName.length() >= 4 && lexicalName.charAt(0) == 'Q' && lexicalName.charAt(1) == '{') {
            String name = lexicalName.toString();
            int endBrace = name.indexOf(125, 2);
            if (endBrace < 0) {
                throw new XPathException("Invalid EQName: closing brace not found", "FOCA0002");
            }
            if (endBrace == name.length() - 1) {
                throw new XPathException("Invalid EQName: local part is missing", "FOCA0002");
            }
            String uri = name.substring(2, endBrace);
            if (uri.indexOf(123, 0) >= 0) {
                throw new XPathException("Namespace URI must not contain '{'", "FOCA0002");
            }
            String local = name.substring(endBrace + 1, name.length());
            if (!NameChecker.isValidNCName(StringTool.codePoints(local))) {
                throw new XPathException("Invalid EQName: local part is not a valid NCName", "FOCA0002");
            }
            return new StructuredQName("", NamespaceUri.of(uri), local);
        }
        try {
            String[] parts = NameChecker.getQNameParts(lexicalName);
            NamespaceUri uri = resolver.getURIForPrefix(parts[0], useDefault);
            if (uri == null) {
                if (NameChecker.isValidNCName(parts[0])) {
                    throw new XPathException("Namespace prefix '" + parts[0] + "' has not been declared", "FONS0004");
                }
                throw new XPathException("Invalid namespace prefix '" + parts[0] + "'", "FOCA0002");
            }
            return new StructuredQName(parts[0], uri, parts[1]);
        }
        catch (QNameException e) {
            throw new XPathException(e.getMessage(), "FOCA0002");
        }
    }

    public static StructuredQName fromEQName(String eqName) {
        if ((eqName = Whitespace.trim(eqName)).length() >= 4 && eqName.startsWith("Q{")) {
            int endBrace = eqName.indexOf(125);
            if (endBrace < 0) {
                throw new IllegalArgumentException("Invalid EQName: closing brace not found");
            }
            if (endBrace == eqName.length() - 1) {
                throw new IllegalArgumentException("Invalid EQName: local part is missing");
            }
            String uri = eqName.substring(2, endBrace);
            if (uri.indexOf(123) >= 0) {
                throw new IllegalArgumentException("Invalid EQName: open brace in URI part");
            }
            String local = eqName.substring(endBrace + 1);
            return new StructuredQName("", NamespaceUri.of(uri), local);
        }
        return new StructuredQName("", NamespaceUri.NULL, eqName);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public NamespaceUri getNamespaceUri() {
        return this.uri;
    }

    public String getURI() {
        return this.uri.toString();
    }

    public boolean hasURI(NamespaceUri uri) {
        return this.uri == uri;
    }

    public String getLocalPart() {
        return this.local;
    }

    public String getDisplayName() {
        if (this.prefix.isEmpty()) {
            return this.local;
        }
        return this.prefix + ":" + this.local;
    }

    public StructuredQName getStructuredQName() {
        return this;
    }

    public String getClarkName() {
        if (this.uri == NamespaceUri.NULL) {
            return this.local;
        }
        return "{" + String.valueOf(this.uri) + "}" + this.local;
    }

    public String getEQName() {
        if (this.uri == NamespaceUri.NULL) {
            return "Q{}" + this.local;
        }
        return "Q{" + String.valueOf(this.uri) + "}" + this.local;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StructuredQName) {
            return this.local.equals(((StructuredQName)other).local) && this.uri == ((StructuredQName)other).uri;
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            this.cachedHashCode = 0x5004A00B ^ this.local.hashCode() ^ this.uri.hashCode();
            return this.cachedHashCode;
        }
        return this.cachedHashCode;
    }

    public static int computeHashCode(NamespaceUri uri, String local) {
        return 0x5004A00B ^ local.hashCode() ^ uri.hashCode();
    }

    public QName toJaxpQName() {
        return new QName(this.getNamespaceUri().toString(), this.getLocalPart(), this.getPrefix());
    }

    public NamespaceBinding getNamespaceBinding() {
        return new NamespaceBinding(this.getPrefix(), this.getNamespaceUri());
    }

    @Override
    public boolean isIdentical(IdentityComparable other) {
        return this.equals(other) && ((StructuredQName)other).getPrefix().equals(this.getPrefix());
    }

    @Override
    public int identityHashCode() {
        return this.hashCode() ^ this.getPrefix().hashCode();
    }
}

