/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Whitespace;

public class StringToDouble
extends StringConverter {
    private static final StringToDouble THE_INSTANCE = new StringToDouble();
    private static final double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8};

    public static StringToDouble getInstance() {
        return THE_INSTANCE;
    }

    protected StringToDouble() {
    }

    public double stringToNumber(UnicodeString s) throws NumberFormatException {
        String n;
        int len = s.length32();
        boolean containsDisallowedChars = false;
        boolean containsWhitespace = false;
        if (len < 9) {
            boolean useJava = false;
            long num = 0L;
            int dot = -1;
            int lastDigit = -1;
            boolean onlySpaceAllowed = false;
            boolean breakLoop = false;
            for (int i = 0; i < len; ++i) {
                int c = s.codePointAt(i);
                switch (c) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        containsWhitespace = true;
                        if (lastDigit == -1) break;
                        onlySpaceAllowed = true;
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        lastDigit = i;
                        num = num * 10L + (long)(c - 48);
                        break;
                    }
                    case 46: {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        if (dot != -1) {
                            throw new NumberFormatException("Only one decimal point allowed");
                        }
                        dot = i;
                        break;
                    }
                    case 68: 
                    case 70: 
                    case 78: 
                    case 88: 
                    case 100: 
                    case 102: 
                    case 110: 
                    case 120: {
                        containsDisallowedChars = true;
                        useJava = true;
                        breakLoop = true;
                        break;
                    }
                    default: {
                        useJava = true;
                    }
                }
                if (breakLoop) break;
            }
            if (!useJava) {
                if (lastDigit == -1) {
                    throw new NumberFormatException("String to double conversion: no digits found");
                }
                if (dot == -1 || dot > lastDigit) {
                    return num;
                }
                int afterPoint = lastDigit - dot;
                return (double)num / powers[afterPoint];
            }
        } else {
            boolean breakLoop2 = false;
            for (int i = 0; i < len; ++i) {
                int c = s.codePointAt(i);
                switch (c) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        containsWhitespace = true;
                        break;
                    }
                    case 43: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 69: 
                    case 101: {
                        break;
                    }
                    default: {
                        containsDisallowedChars = true;
                        breakLoop2 = true;
                    }
                }
                if (breakLoop2) break;
            }
        }
        String string = n = containsWhitespace ? Whitespace.trim(s).toString() : s.toString();
        if ("INF".equals(n)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("+INF".equals(n)) {
            return this.signedPositiveInfinity();
        }
        if ("-INF".equals(n)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(n)) {
            return Double.NaN;
        }
        if (containsDisallowedChars) {
            throw new NumberFormatException("invalid floating point value: " + String.valueOf(s));
        }
        return Double.parseDouble(n);
    }

    protected double signedPositiveInfinity() {
        throw new NumberFormatException("the float/double value '+INF' is not allowed under XSD 1.0");
    }

    @Override
    public ConversionResult convertString(UnicodeString input) {
        try {
            double d = this.stringToNumber(input);
            return new DoubleValue(d);
        }
        catch (NumberFormatException e) {
            return new ValidationFailure("Cannot convert string " + Err.wrap(input, 4) + " to double");
        }
    }
}

