/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.Root_1;
import net.sf.saxon.functions.SuperId;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.BooleanExpressionPattern;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.pattern.UniversalPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;

public class PatternParser30
extends XPathParser
implements PatternParser {
    int inPredicate = 0;

    public Pattern parsePattern(String pattern, StaticContext env, int lineNumber) throws XPathException {
        this.env = env;
        this.charChecker = env.getConfiguration().getValidCharacterChecker();
        this.language = 1;
        String trimmed = pattern.trim();
        if (trimmed.startsWith("(:")) {
            Tokenizer t = new Tokenizer();
            t.languageLevel = 30;
            t.tokenize(trimmed, 0, -1);
            int start = t.currentTokenStartOffset;
            trimmed = trimmed.substring(start);
        }
        if (trimmed.startsWith(".")) {
            Expression e = this.parse(pattern, 0, 0, env);
            if (e instanceof ContextItemExpression) {
                return new UniversalPattern();
            }
            if (e instanceof FilterExpression) {
                Expression predicate = null;
                while (e instanceof FilterExpression) {
                    Expression filter = ((FilterExpression)e).getActionExpression();
                    e = ((FilterExpression)e).getSelectExpression();
                    ItemType filterType = filter.getItemType();
                    TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
                    int rel = th.relationship(filterType, NumericType.getInstance());
                    if (rel != 4) {
                        if (rel == 0 || rel == 2) {
                            filter = new ValueComparison(filter, 50, Literal.makeLiteral(Int64Value.PLUS_ONE));
                        } else {
                            LetExpression let = new LetExpression();
                            StructuredQName varName = new StructuredQName("vv", "http://saxon.sf.net/generated-variable", "v" + filter.hashCode());
                            let.setVariableQName(varName);
                            InstanceOfExpression condition = new InstanceOfExpression(new LocalVariableReference(let), SequenceType.SINGLE_NUMERIC);
                            LocalVariableReference ref = new LocalVariableReference(let);
                            ref.setStaticType(SequenceType.SINGLE_NUMERIC, null, 0);
                            ValueComparison comparison = new ValueComparison(ref, 50, Literal.makeLiteral(Int64Value.PLUS_ONE));
                            Choose choice = new Choose(new Expression[]{condition, Literal.makeLiteral(BooleanValue.TRUE)}, new Expression[]{comparison, new LocalVariableReference(let)});
                            let.setSequence(filter);
                            let.setAction(choice);
                            let.setRequiredType(SequenceType.ANY_SEQUENCE);
                            let.setRetainedStaticContext(env.makeRetainedStaticContext());
                            filter = let;
                        }
                    }
                    if (predicate == null) {
                        predicate = filter;
                        continue;
                    }
                    predicate = new AndExpression(filter, predicate);
                }
                if (e instanceof ContextItemExpression) {
                    return new BooleanExpressionPattern(predicate);
                }
            }
            this.grumble("Pattern starting with '.' must be followed by a sequence of predicates");
            return null;
        }
        Expression exp = this.parse(pattern, 0, 0, env);
        exp.setRetainedStaticContext(env.makeRetainedStaticContext());
        if (exp instanceof VennExpression) {
            this.checkNoPredicatePattern(((VennExpression)exp).getLhsExpression());
            this.checkNoPredicatePattern(((VennExpression)exp).getRhsExpression());
        }
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        ContextItemStaticInfo cit = visitor.getConfiguration().makeContextItemStaticInfo(AnyNodeTest.getInstance(), true);
        Pattern pat = PatternMaker.fromExpression(exp.simplify().typeCheck(visitor, cit), env.getConfiguration(), true);
        if (exp instanceof FilterExpression && ((FilterExpression)exp).getBase() instanceof ContextItemExpression) {
            this.grumble("A predicatePattern can appear only at the outermost level (parentheses not allowed)");
        }
        if (exp instanceof FilterExpression && pat instanceof NodeTestPattern) {
            pat.setPriority(0.5);
        }
        return pat;
    }

    private void checkNoPredicatePattern(Expression exp) throws XPathException {
        if (exp instanceof ContextItemExpression) {
            this.grumble("A predicatePattern can appear only at the outermost level (union operator not allowed)");
        }
        if (exp instanceof FilterExpression) {
            this.checkNoPredicatePattern(((FilterExpression)exp).getBase());
        }
        if (exp instanceof VennExpression) {
            this.checkNoPredicatePattern(((VennExpression)exp).getLhsExpression());
            this.checkNoPredicatePattern(((VennExpression)exp).getRhsExpression());
        }
    }

    protected void customizeTokenizer(Tokenizer t) {
    }

    public Expression parseExpression() throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseExpression();
        }
        return this.parseBinaryExpression(this.parsePathExpression(), 10);
    }

    protected Expression parseBasicStep(boolean firstInPattern) throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseBasicStep(firstInPattern);
        }
        switch (this.t.currentToken) {
            case 21: {
                if (!firstInPattern) {
                    this.grumble("In an XSLT 3.0 pattern, a variable reference is allowed only as the first step in a path");
                    return null;
                }
                return super.parseBasicStep(firstInPattern);
            }
            case 43: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 202: 
            case 206: 
            case 209: 
            case 217: {
                this.grumble("Token " + this.currentTokenDisplay() + " not allowed here in an XSLT pattern");
                return null;
            }
            case 35: {
                if (!firstInPattern) {
                    this.grumble("In an XSLT pattern, a function call is allowed only as the first step in a path");
                }
                return super.parseBasicStep(firstInPattern);
            }
        }
        return super.parseBasicStep(firstInPattern);
    }

    protected void testPermittedAxis(byte axis, String errorCode) throws XPathException {
        if (this.inPredicate == 0 && !AxisInfo.isSubtreeAxis[axis]) {
            this.grumble("The " + AxisInfo.axisName[axis] + " is not allowed in a pattern");
        }
    }

    protected Expression parsePredicate() throws XPathException {
        boolean disallow = this.t.disallowUnionKeyword;
        this.t.disallowUnionKeyword = false;
        ++this.inPredicate;
        Expression exp = this.parseExpression();
        --this.inPredicate;
        this.t.disallowUnionKeyword = disallow;
        return exp;
    }

    public Expression parseFunctionCall(Expression prefixArgument) throws XPathException {
        Expression fn = super.parseFunctionCall(prefixArgument);
        if (!(this.inPredicate > 0 || fn.isCallOn(SuperId.class) || fn.isCallOn(KeyFn.class) || fn.isCallOn(Doc.class) || fn.isCallOn(Root_1.class))) {
            this.grumble("The " + fn.toString() + " function is not allowed at the head of a pattern");
        }
        return fn;
    }

    public Expression parseFunctionArgument() throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseFunctionArgument();
        }
        switch (this.t.currentToken) {
            case 21: {
                return this.parseVariableReference();
            }
            case 202: {
                return this.parseStringLiteral(true);
            }
            case 209: {
                return this.parseNumericLiteral(true);
            }
        }
        this.grumble("A function argument in an XSLT pattern must be a variable reference or literal");
        return null;
    }

    public Expression makeTracer(int startOffset, Expression exp, int construct, StructuredQName qName) {
        return exp;
    }
}

