/*
 * Decompiled with CFR 0.152.
 */
package javawebparts.misc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javawebparts.core.JWPHelpers;

public final class RecordedRequestPlayer {
    private RecordedRequestPlayer() {
    }

    public static void main(String[] args) {
        System.out.println("\nJava Web Parts - RecordedRequestPlayer\n");
        if (args.length < 3) {
            RecordedRequestPlayer.displayUsageInfo();
            System.exit(-1);
        }
        String fileName = args[0];
        String numReps = args[1];
        String numThreads = args[2];
        int iNumReps = 0;
        int iNumThreads = 0;
        try {
            iNumReps = Integer.parseInt(numReps);
        }
        catch (NumberFormatException nfe) {
            RecordedRequestPlayer.displayUsageInfo();
            System.exit(-1);
        }
        if (iNumReps == 0) {
            iNumReps = 2000000000;
        }
        try {
            iNumThreads = Integer.parseInt(numThreads);
        }
        catch (NumberFormatException nfe) {
            RecordedRequestPlayer.displayUsageInfo();
            System.exit(-1);
        }
        if (iNumThreads <= 0) {
            RecordedRequestPlayer.displayUsageInfo();
            System.exit(-1);
        }
        String[] requests = null;
        try {
            requests = JWPHelpers.readFromFile((String)fileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("The file " + fileName + " could not be found, " + "exiting.");
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.out.println("IOException reading file: " + ioe);
            System.exit(-1);
        }
        if (requests == null || requests.length == 0) {
            System.out.println("No requests found in file, exiting.");
            System.exit(0);
        }
        ArrayList requestsAL = new ArrayList();
        for (int i = 0; i < requests.length; ++i) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            StringTokenizer st = new StringTokenizer(requests[i], ",");
            hm.put("method", st.nextToken());
            hm.put("theURL", st.nextToken());
            HashMap<String, String> params = new HashMap<String, String>();
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(param, "=");
                String pName = st1.nextToken();
                String pVal = st1.nextToken();
                params.put(pName, pVal);
            }
            hm.put("parameters", params);
            requestsAL.add(hm);
        }
        System.out.println("Running...\n");
        RunnerThread[] threads = new RunnerThread[iNumThreads];
        for (int i = 0; i < iNumThreads; ++i) {
            threads[i] = new RunnerThread();
            threads[i].setReps(iNumReps);
            threads[i].setID(i + 1);
            threads[i].setRequests(requestsAL);
            threads[i].setNumThreads(iNumThreads);
            threads[i].start();
        }
    }

    public static void displayUsageInfo() {
        System.out.println("This is a java application that will \"play  back\" a series of requests");
        System.out.println("recorded with the RequestRecorderFilter.  It accepts two required command");
        System.out.println("line parameters:\n");
        System.out.println("1. The filename containing the recorded requests (full path to it)");
        System.out.println("2. The number of times to run through the file, or 0 for continuous");
        System.out.println("3. The number of concurrent threads to spawn to run through the parameters");
        System.out.println("\nHere is a usage example:\n");
        System.out.println("RecordedRequestPlayer c:\\temp\\saveFile.csv 5 3\n");
        System.out.println("This will run through all the requests in the file saveFile.csv in c:\\temp");
        System.out.println("5 times and then stop, and will spawn 3 threads to do so, essentially");
        System.out.println("simulating 3 simultaneous users.\n");
    }

    public static class RunnerThread
    extends Thread {
        private int reps;
        private int repsCount;
        private int id;
        private ArrayList requests;
        private int responseCode;
        private String responseMessage;
        private int numThreads;

        public void setReps(int inReps) {
            this.reps = inReps;
        }

        public void setID(int inID) {
            this.id = inID;
        }

        public void setRequests(ArrayList inRequests) {
            this.requests = inRequests;
        }

        public void setNumThreads(int inNumThreads) {
            this.numThreads = inNumThreads;
        }

        public void run() {
            this.repsCount = 0;
            while (this.repsCount < this.reps) {
                int i = 0;
                Iterator it = this.requests.iterator();
                while (it.hasNext()) {
                    ++i;
                    HashMap reqData = (HashMap)it.next();
                    String method = (String)reqData.get("method");
                    String theURL = (String)reqData.get("theURL");
                    HashMap params = (HashMap)reqData.get("parameters");
                    StringBuffer sb = new StringBuffer(1024);
                    sb.append("* Thread:     " + this.id + "/" + this.numThreads + "\n");
                    sb.append("* Repetition: " + (this.repsCount + 1) + "/" + this.reps + "\n");
                    sb.append("* Request:    " + i + "/" + this.requests.size() + "\n");
                    sb.append("* URL:        " + theURL + "\n");
                    sb.append("* Parameters: ");
                    if (params.isEmpty()) {
                        sb.append("None");
                    } else {
                        String p = params.toString();
                        sb.append(p.substring(1, p.length() - 1));
                    }
                    this.sendRequest(theURL, method, params);
                    sb.append("\n* Response:   " + this.responseCode + " " + this.responseMessage + "\n");
                    this.log(sb);
                }
                ++this.repsCount;
            }
        }

        private void sendRequest(String theURL, String method, HashMap params) {
            String queryString = "";
            if (method.equalsIgnoreCase("get")) {
                boolean didOne = false;
                Iterator it = params.keySet().iterator();
                while (it.hasNext()) {
                    if (didOne) {
                        queryString = queryString + ",";
                    } else {
                        didOne = true;
                    }
                    String pName = (String)it.next();
                    queryString = queryString + pName + "=" + (String)params.get(pName);
                }
            }
            try {
                URL u = new URL(theURL + "?" + queryString);
                URLConnection uc = u.openConnection();
                HttpURLConnection huc = (HttpURLConnection)uc;
                huc.setUseCaches(false);
                huc.setDoOutput(true);
                huc.setRequestMethod(method);
                if (method.equalsIgnoreCase("post")) {
                    OutputStreamWriter wr = new OutputStreamWriter(huc.getOutputStream());
                    wr.write(queryString);
                    wr.flush();
                    wr.close();
                }
                this.responseCode = huc.getResponseCode();
                this.responseMessage = huc.getResponseMessage();
            }
            catch (IOException ioe) {
                this.responseCode = -1;
                this.responseMessage = ioe.toString();
            }
        }

        private void log(StringBuffer sb) {
            System.out.println(sb);
        }
    }
}

