/*
 * Decompiled with CFR 0.152.
 */
package javawebparts.misc.chain;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javawebparts.misc.chain.Chain;
import javawebparts.misc.chain.ChainManager;

public class Catalog {
    private String id = "";
    private String extendsID;
    private Map chains = new HashMap();

    public Catalog() {
        this(null, null);
    }

    public Catalog(String inID, String inExtendsID) {
        this.id = inID;
        this.setExtendsID(inExtendsID);
    }

    public Map cloneChains() {
        HashMap<String, Chain> clonedChains = new HashMap<String, Chain>();
        Iterator it = this.chains.keySet().iterator();
        while (it.hasNext()) {
            String chainID = (String)it.next();
            Chain originalChain = (Chain)this.chains.get(chainID);
            Chain clonedChain = new Chain(chainID, null);
            clonedChain.setCommands(originalChain.cloneCommands());
            clonedChains.put(chainID, clonedChain);
        }
        return clonedChains;
    }

    public void setId(String inID) {
        this.id = inID;
    }

    public String getId() {
        return this.id;
    }

    public void setExtendsID(String inExtendsID) {
        this.extendsID = inExtendsID;
        if (this.extendsID != null) {
            Catalog catalog = ChainManager.findCatalog(inExtendsID);
            this.chains = catalog.cloneChains();
        }
    }

    public String getExtendsID() {
        return this.extendsID;
    }

    public void addChain(Chain inChain) {
        this.chains.put(inChain.getId(), inChain);
    }

    public Chain findChain(String inID) {
        return (Chain)this.chains.get(inID);
    }

    public String toString() {
        String str = null;
        StringBuffer sb = new StringBuffer(1000);
        sb.append("[" + super.toString() + "]={\n");
        boolean firstPropertyDisplayed = false;
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (firstPropertyDisplayed) {
                    sb.append("\n");
                } else {
                    firstPropertyDisplayed = true;
                }
                sb.append(fields[i].getName() + "=" + fields[i].get(this));
            }
            sb.append("\n}");
            str = sb.toString().trim();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return str;
    }
}

