/*
 * Decompiled with CFR 0.152.
 */
package javawebparts.misc.chain;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javawebparts.core.org.apache.commons.beanutils.BeanUtils;
import javawebparts.misc.chain.Catalog;
import javawebparts.misc.chain.ChainContext;
import javawebparts.misc.chain.ChainManager;
import javawebparts.misc.chain.Command;
import javawebparts.misc.chain.CommandConfig;
import javawebparts.misc.chain.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Chain {
    private static Log log;
    private List commands = new ArrayList();
    private int executionIndex;
    private String id = "";
    private String extendsID;

    public Chain() {
        this(null, null);
    }

    public Chain(String inID, String inExtendsID) {
        this.id = inID;
        this.setExtendsID(inExtendsID);
    }

    public List cloneCommands() {
        ArrayList<CommandConfig> clonedCommands = new ArrayList<CommandConfig>();
        Iterator it = this.commands.iterator();
        while (it.hasNext()) {
            CommandConfig originalCommandConfig = (CommandConfig)it.next();
            CommandConfig clonedCommandConfig = new CommandConfig(originalCommandConfig.getId(), originalCommandConfig.getClassName(), originalCommandConfig.getChain(), originalCommandConfig.getReplaceID());
            clonedCommandConfig.setProperties(originalCommandConfig.cloneProperties());
            clonedCommands.add(clonedCommandConfig);
        }
        return clonedCommands;
    }

    public void setId(String inID) {
        this.id = inID;
    }

    public String getId() {
        return this.id;
    }

    public void setExtendsID(String inExtendsID) {
        this.extendsID = inExtendsID;
        String catalogID = null;
        String chainID = null;
        if (this.extendsID != null) {
            catalogID = ChainManager.getCatalogOrChainID(inExtendsID, 1);
            chainID = ChainManager.getCatalogOrChainID(inExtendsID, 2);
            if (catalogID == null || chainID == null) {
                log.error((Object)"extends attribute of chain element must be in the form CatalogID/ChainID");
            } else {
                Catalog catalog = ChainManager.findCatalog(catalogID);
                Chain chain = catalog.findChain(chainID);
                this.commands = chain.cloneCommands();
            }
        }
    }

    public String getExtendsID() {
        return this.extendsID;
    }

    public void addCommand(CommandConfig inCommand) {
        String replaceID = inCommand.getReplaceID();
        if (replaceID == null) {
            this.commands.add(inCommand);
        } else {
            int i = 0;
            Iterator it = this.commands.iterator();
            while (it.hasNext()) {
                CommandConfig commandConfig = (CommandConfig)it.next();
                if (replaceID.equals(commandConfig.getId())) {
                    this.commands.set(i, inCommand);
                    break;
                }
                ++i;
            }
        }
    }

    public void setCommands(List inCommands) {
        this.commands = inCommands;
    }

    public Result execute(ChainManager chainManager, ChainContext chainContext) {
        Result theResult = new Result(1);
        try {
            this.executionIndex = 0;
            while (this.executionIndex < this.commands.size()) {
                String prefix = chainContext.getCatalogId() + "_" + chainContext.getChainId() + "_";
                chainContext.setAttribute(prefix + "executionIndex", new Integer(this.executionIndex));
                CommandConfig commandConfig = (CommandConfig)this.commands.get(this.executionIndex);
                log.info((Object)("Next Command to execute config = " + commandConfig));
                if (commandConfig.getClassName() == null) {
                    String chainID = commandConfig.getChain();
                    if (chainID.indexOf("/") == -1) {
                        chainID = chainContext.getCatalogId() + "/" + chainID;
                    }
                    chainManager.executeChain(chainID, chainContext);
                    theResult = chainContext.getResult();
                    if (theResult.getCode() == 4) {
                        this.executionIndex = -1;
                        chainContext.setAttribute(prefix + "executionIndex", new Integer(this.executionIndex));
                    }
                    if (theResult.getCode() == 5) {
                        --this.executionIndex;
                        chainContext.setAttribute(prefix + "executionIndex", new Integer(this.executionIndex));
                    }
                    if (theResult.getCode() == 2 || theResult.getCode() == 3) {
                        break;
                    }
                } else {
                    String className = commandConfig.getClassName();
                    Class<?> clazz = Class.forName(className);
                    Command command = (Command)clazz.newInstance();
                    Iterator it = commandConfig.getProperties().iterator();
                    while (it.hasNext()) {
                        Map m = (Map)it.next();
                        String name = (String)m.get("name");
                        String value = (String)m.get("value");
                        BeanUtils.setProperty((Object)command, (String)name, (Object)value);
                    }
                    theResult = command.init(chainContext);
                    if (theResult.getCode() == 2 || theResult.getCode() == 3) break;
                    theResult = command.execute(chainContext);
                    if (theResult.getCode() == 4) {
                        this.executionIndex = -1;
                        chainContext.setAttribute(prefix + "executionIndex", new Integer(this.executionIndex));
                    }
                    if (theResult.getCode() == 5) {
                        --this.executionIndex;
                        chainContext.setAttribute(prefix + "executionIndex", new Integer(this.executionIndex));
                    }
                    if (theResult.getCode() == 6) {
                        String targetCommand = theResult.getTargetCommand();
                        if (targetCommand == null) {
                            log.error((Object)"JUMP_TO_COMMAND returned but targetCommand was null, so cannot perform jump, Chain execution will FAIL.");
                            command.cleanup(chainContext);
                            theResult = new Result(2, "JUMP_TO_COMMAND requested but target command was not set by Command");
                            break;
                        }
                        boolean foundIt = false;
                        for (int newIndex = 0; newIndex < this.commands.size(); ++newIndex) {
                            CommandConfig findCC = (CommandConfig)this.commands.get(newIndex);
                            if (!targetCommand.equals(findCC.getId())) continue;
                            foundIt = true;
                            this.executionIndex = newIndex - 1;
                            chainContext.setAttribute(prefix + "executionIndex", new Integer(this.executionIndex));
                            if (!log.isDebugEnabled()) break;
                            log.debug((Object)("JUMP_TO_COMMAND targetCommand = " + targetCommand + " found, jumping to index " + newIndex + "..."));
                            break;
                        }
                        if (!foundIt) {
                            log.error((Object)("JUMP_TO_COMMAND targetCommand = " + targetCommand + " *NOT* found, Chain execution will FAIL."));
                            theResult = new Result(2, "JUMP_TO_COMMAND requested but target command '" + targetCommand + "' could not be " + "found in Chain");
                            break;
                        }
                    }
                    if (theResult.getCode() == 2 || theResult.getCode() == 3) {
                        command.cleanup(chainContext);
                        break;
                    }
                    theResult = command.cleanup(chainContext);
                    if (theResult.getCode() == 2 || theResult.getCode() == 3) break;
                }
                this.executionIndex = (Integer)chainContext.getAttribute(prefix + "executionIndex");
                ++this.executionIndex;
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Object)("Chain execution FAILED due to Exception - " + cnfe));
            theResult = new Result(2, "ClassNotFoundException");
        }
        catch (InstantiationException ie) {
            log.error((Object)("Chain execution FAILED due to Exception - " + ie));
            theResult = new Result(2, "InstantiationException");
        }
        catch (IllegalAccessException iae) {
            log.error((Object)("Chain execution FAILED due to Exception - " + iae));
            theResult = new Result(2, "IllegalAccessException");
        }
        catch (InvocationTargetException ite) {
            log.error((Object)("Chain execution FAILED due to Exception - " + ite));
            theResult = new Result(2, "InvocationTargetException");
        }
        return theResult;
    }

    public String toString() {
        String str = null;
        StringBuffer sb = new StringBuffer(1000);
        sb.append("[" + super.toString() + "]={\n");
        boolean firstPropertyDisplayed = false;
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (firstPropertyDisplayed) {
                    sb.append("\n");
                } else {
                    firstPropertyDisplayed = true;
                }
                sb.append(fields[i].getName() + "=" + fields[i].get(this));
            }
            sb.append("\n}");
            str = sb.toString().trim();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return str;
    }

    static {
        try {
            Class.forName("javawebparts.core.org.apache.commons.beanutils.BeanUtils");
            Class.forName("org.apache.commons.logging.Log");
            Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Chain could not be loaded by classloader because classes it depends on could not be found in the classpath...");
            e.printStackTrace();
        }
        log = LogFactory.getLog((Class)Chain.class);
    }
}

