/*
 * Decompiled with CFR 0.152.
 */
package javawebparts.misc.chain;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javawebparts.core.org.apache.commons.digester.Digester;
import javawebparts.core.org.apache.commons.digester.ExtendedBaseRules;
import javawebparts.core.org.apache.commons.digester.Rules;
import javawebparts.misc.chain.Catalog;
import javawebparts.misc.chain.Chain;
import javawebparts.misc.chain.ChainContext;
import javawebparts.misc.chain.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ChainManager {
    public static final String DEFAULT_FILE_NAME = "/chain_config.xml";
    public static final int CATALOG_ID = 1;
    public static final int CHAIN_ID = 2;
    private static Log log;
    private static Map catalogs;
    private static boolean configured;

    public ChainManager() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ChainManager(String inConfigFilename) {
        super();
        ChainManager.log.info((Object)"ChainManager...");
        if (!ChainManager.configured) {
            block20: {
                stream = null;
                try {
                    block19: {
                        configFilename = inConfigFilename;
                        if (configFilename == null && (evFilename = System.getProperty("JWP_CHAIN_CONFIG_FILE_NAME")) != null) {
                            configFilename = evFilename;
                        }
                        if (configFilename == null) {
                            configFilename = "/chain_config.xml";
                        }
                        if ((stream = (loader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(configFilename)) != null) {
                            digester = new Digester();
                            digester.setRules((Rules)new ExtendedBaseRules());
                            digester.setValidating(false);
                            digester.push((Object)this);
                            digester.addObjectCreate("chainConfig/catalog", "javawebparts.misc.chain.Catalog");
                            digester.addSetProperties("chainConfig/catalog");
                            digester.addObjectCreate("chainConfig/catalog/chain", "javawebparts.misc.chain.Chain");
                            digester.addSetProperties("chainConfig/catalog/chain");
                            digester.addObjectCreate("chainConfig/catalog/chain/command", "javawebparts.misc.chain.CommandConfig");
                            digester.addSetProperties("chainConfig/catalog/chain/command");
                            digester.addCallMethod("chainConfig/catalog/chain/command/property", "addProperty", 2);
                            digester.addCallParam("chainConfig/catalog/chain/command/property", 0, "id");
                            digester.addCallParam("chainConfig/catalog/chain/command/property", 1, "value");
                            digester.addSetNext("chainConfig/catalog/chain/command", "addCommand");
                            digester.addSetNext("chainConfig/catalog/chain", "addChain");
                            digester.addSetNext("chainConfig/catalog", "addCatalog");
                            digester.parse(stream);
                            ChainManager.log.info((Object)ChainManager.catalogs);
                            ChainManager.log.info((Object)"ChainManager configured");
                            break block19;
                        }
                        ChainManager.log.error((Object)("Couldn't find " + configFilename));
                    }
                    var7_8 = null;
                    ** if (stream == null) goto lbl-1000
                }
                catch (Throwable var6_16) {
                    var7_11 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException ioe) {
                            ChainManager.log.error((Object)("Exception closing config file stream: " + ioe));
                        }
                    }
                    throw var6_16;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        ChainManager.log.error((Object)("Exception closing config file stream: " + ioe));
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block20;
                    catch (IOException ioe) {
                        ChainManager.log.error((Object)("Exception reading config file: " + ioe));
                        var7_9 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException ioe) {
                                ChainManager.log.error((Object)("Exception closing config file stream: " + ioe));
                            }
                        }
                        break block20;
                    }
                    catch (SAXException se) {
                        ChainManager.log.error((Object)("Exception parsing config file: " + se));
                        var7_10 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException ioe) {
                                ChainManager.log.error((Object)("Exception closing config file stream: " + ioe));
                            }
                        }
                    }
                }
            }
            ChainManager.configured = true;
        } else {
            ChainManager.log.info((Object)"ChainManager already configured");
        }
    }

    public void addCatalog(Catalog inCatalog) {
        catalogs.put(inCatalog.getId(), inCatalog);
    }

    public static Catalog findCatalog(String catalogID) {
        return (Catalog)catalogs.get(catalogID);
    }

    public ChainContext createContext() {
        return new ChainContext();
    }

    public void executeChain(String catalogChainID, ChainContext chainContext) {
        Chain chain;
        Catalog catalog;
        log.info((Object)"Getting ready to execute chain...");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Incoming ChainContext: " + chainContext));
        }
        String catalogID = ChainManager.getCatalogOrChainID(catalogChainID, 1);
        String chainID = ChainManager.getCatalogOrChainID(catalogChainID, 2);
        if (catalogID == null || chainID == null) {
            log.error((Object)"Chain execution failed because the specified ID was not in the form CatalogID/ChainID");
            chainContext.setResult(new Result(2));
            return;
        }
        chainContext.setCatalogId(catalogID);
        chainContext.setChainId(chainID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ChainContext before chain began: " + chainContext));
        }
        if ((catalog = ChainManager.findCatalog(catalogID)) == null) {
            log.error((Object)("Chain execution failed because the Catalog " + catalogID + " could not be found"));
            chainContext.setResult(new Result(2));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using Catalog: " + catalog));
        }
        if ((chain = catalog.findChain(chainID)) == null) {
            log.error((Object)("Chain execution failed because the Chain " + chainID + " could not be found"));
            chainContext.setResult(new Result(2));
            return;
        }
        log.info((Object)("Using Chain: " + chain));
        log.info((Object)("Beginning chain '" + chainID + "'..."));
        Result chainResult = chain.execute(this, chainContext);
        chainContext.setResult(chainResult);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ChainContext after chain ended: " + chainContext));
        }
        log.info((Object)"Chain execution complete");
    }

    public static String getCatalogOrChainID(String catalogChainID, int which) {
        String retVal = null;
        if (catalogChainID.indexOf("/") != -1) {
            StringTokenizer st = new StringTokenizer(catalogChainID, "/");
            String catalogID = st.nextToken();
            String chainID = st.nextToken();
            if (which == 1) {
                retVal = catalogID;
            }
            if (which == 2) {
                retVal = chainID;
            }
        }
        return retVal;
    }

    public String toString() {
        String str = null;
        StringBuffer sb = new StringBuffer(1000);
        sb.append("[" + super.toString() + "]={\n");
        boolean firstPropertyDisplayed = false;
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (firstPropertyDisplayed) {
                    sb.append("\n");
                } else {
                    firstPropertyDisplayed = true;
                }
                sb.append(fields[i].getName() + "=" + fields[i].get(this));
            }
            sb.append("\n}");
            str = sb.toString().trim();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return str;
    }

    static {
        try {
            Class.forName("javawebparts.core.org.apache.commons.digester.Digester");
            Class.forName("javawebparts.core.org.apache.commons.digester.ExtendedBaseRules");
            Class.forName("org.apache.commons.logging.Log");
            Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException e) {
            System.err.println("ChainManager could not be loaded by classloader because classes it depends on could not be found in the classpath...");
            e.printStackTrace();
        }
        log = LogFactory.getLog((Class)ChainManager.class);
        catalogs = new HashMap();
    }
}

