/*
 * Decompiled with CFR 0.152.
 */
package javawebparts.misc.chain.commands;

import javawebparts.misc.chain.ChainContext;
import javawebparts.misc.chain.Command;
import javawebparts.misc.chain.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoopEndCommand
implements Command {
    private static Log log;

    public Result init(ChainContext chainContext) {
        return new Result(1);
    }

    public Result execute(ChainContext chainContext) {
        String prefix = chainContext.getCatalogId() + "_" + chainContext.getChainId() + "_";
        String inLoop = (String)chainContext.getAttribute(prefix + "inLoop");
        if (inLoop == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)">>>>>>>> Not in loop, skipping Command");
            }
            return new Result(1);
        }
        int loopIndex = (Integer)chainContext.getAttribute(prefix + "indexVar");
        int indexEnd = (Integer)chainContext.getAttribute(prefix + "indexEnd");
        if (++loopIndex > indexEnd) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loop ending");
            }
            chainContext.setAttribute(prefix + "inLoop", null);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loop continuing");
            }
            chainContext.setAttribute(prefix + "indexVar", new Integer(loopIndex));
            chainContext.setAttribute(prefix + "executionIndex", chainContext.getAttribute(prefix + "loopFirstCommandIndex"));
        }
        return new Result(1);
    }

    public Result cleanup(ChainContext chainContext) {
        return new Result(1);
    }

    static {
        try {
            Class.forName("javawebparts.misc.chain.ChainContext");
            Class.forName("javawebparts.misc.chain.Command");
            Class.forName("javawebparts.misc.chain.Result");
            Class.forName("org.apache.commons.logging.Log");
            Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException e) {
            System.err.println("LoopEndCommand could not be loaded by classloader because classes it depends on could not be found in the classpath...");
            e.printStackTrace();
        }
        log = LogFactory.getLog((Class)LoopEndCommand.class);
    }
}

