/*
 * Decompiled with CFR 0.152.
 */
package javawebparts.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import javawebparts.core.org.apache.commons.digester.Digester;
import javawebparts.servlet.ResourceStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ResourceServerServlet
extends HttpServlet {
    private static Log log;
    private String requestParameter;
    private String resourceStreamClass;
    private String resourceMappingFile;
    private boolean serveUnbounded;
    private String defaultContentType;
    private HashMap mappings = new HashMap();
    private String streamParam1;
    private String streamParam2;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.streamParam1 = config.getInitParameter("streamParam1");
        this.streamParam2 = config.getInitParameter("streamParam2");
        String rp = config.getInitParameter("requestParameter");
        if (rp == null || rp.equalsIgnoreCase("")) {
            log.info((Object)"init parameter requestParameter not found, defaulting to 'res'");
            this.requestParameter = "res";
        } else {
            this.requestParameter = rp;
        }
        this.resourceStreamClass = config.getInitParameter("resourceStreamClass");
        if (this.resourceStreamClass == null || this.resourceStreamClass.equalsIgnoreCase("")) {
            String e = "Required init parameter resourceStreamClass not present";
            log.error((Object)e);
            throw new ServletException(e);
        }
        this.defaultContentType = config.getInitParameter("defaultContentType");
        if (this.defaultContentType == null || this.defaultContentType.equalsIgnoreCase("")) {
            String e = "Required init parameter defaultContentType not present";
            log.error((Object)e);
            throw new ServletException(e);
        }
        String su = config.getInitParameter("serveUnbounded");
        if (su == null || su.equalsIgnoreCase("")) {
            log.info((Object)"init parameter serveUnbounded not found, defaulting to false");
            this.serveUnbounded = false;
        } else if (su.equalsIgnoreCase("true")) {
            this.serveUnbounded = true;
        } else if (su.equalsIgnoreCase("false")) {
            this.serveUnbounded = false;
        } else {
            String e = "init parameter serveUnbounded value should be 'true' or 'false'";
            log.error((Object)e);
            throw new ServletException(e);
        }
        String rmf = config.getInitParameter("resourceMappingFile");
        this.resourceMappingFile = rmf == null || rmf.equalsIgnoreCase("") ? null : rmf;
        if (!this.serveUnbounded && this.resourceMappingFile == null) {
            String e = "When serveUnbounded is false, resourceMappingFile is required";
            log.error((Object)e);
            throw new ServletException(e);
        }
        if (this.resourceMappingFile != null) {
            try {
                Digester digester = new Digester();
                digester.setValidating(false);
                digester.push((Object)this);
                digester.addObjectCreate("resourceMappings/mapping", "javawebparts.servlet.ResourceServerServlet$ResourceMapping");
                digester.addSetProperties("resourceMappings/mapping");
                digester.addSetNext("resourceMappings/mapping", "addMapping");
                ServletContext servletContext = config.getServletContext();
                InputStream isMappingsFile = servletContext.getResourceAsStream(this.resourceMappingFile);
                digester.parse(isMappingsFile);
            }
            catch (IOException ioe) {
                log.error((Object)"IOException reading mappings file.");
            }
            catch (SAXException saxe) {
                log.error((Object)"SAXException reading mappings file.  XML valid?");
            }
        }
        log.info((Object)this);
        log.info((Object)"init() completed");
    }

    public void addMapping(ResourceMapping rm) {
        this.mappings.put(rm.getResource(), rm);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestedResource = request.getParameter(this.requestParameter);
        if (requestedResource == null) {
            log.info((Object)"No resource requested");
            return;
        }
        ResourceMapping rm = (ResourceMapping)this.mappings.get(requestedResource);
        if (!this.serveUnbounded && rm == null) {
            return;
        }
        InputStream is = null;
        ResourceStream rs = null;
        try {
            try {
                Class<?> clazz = Class.forName(this.resourceStreamClass);
                rs = (ResourceStream)clazz.newInstance();
                is = rs.getStream(requestedResource, this.streamParam1, this.streamParam2, this.getServletContext());
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServletException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new ServletException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new ServletException((Throwable)iae);
            }
            if (is != null) {
                int bytesRead;
                String contentType = rs.getContentType(requestedResource, this.streamParam1, this.streamParam2, this.getServletContext());
                if (rm != null) {
                    contentType = rm.getContentType();
                }
                if (contentType == null) {
                    contentType = this.defaultContentType;
                }
                response.setContentType(contentType);
                ServletOutputStream out = response.getOutputStream();
                byte[] buffer = new byte[4096];
                int totalBytesRead = 0;
                while ((bytesRead = is.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesRead += bytesRead;
                }
                response.setContentLength(totalBytesRead);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        String str = null;
        StringBuffer sb = new StringBuffer(1000);
        sb.append("[" + super.toString() + "]={");
        boolean firstPropertyDisplayed = false;
        try {
            Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (firstPropertyDisplayed) {
                    sb.append(", ");
                } else {
                    firstPropertyDisplayed = true;
                }
                sb.append(fields[i].getName() + "=" + fields[i].get((Object)this));
            }
            sb.append("}");
            str = sb.toString().trim();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return str;
    }

    static {
        try {
            Class.forName("javawebparts.core.org.apache.commons.digester.Digester");
            Class.forName("javax.servlet.http.HttpServlet");
            Class.forName("javax.servlet.http.HttpServletRequest");
            Class.forName("javax.servlet.http.HttpServletResponse");
            Class.forName("javax.servlet.ServletConfig");
            Class.forName("javax.servlet.ServletContext");
            Class.forName("javax.servlet.ServletException");
            Class.forName("org.apache.commons.logging.Log");
            Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException e) {
            System.err.println("ResourceServerServlet could not be loaded by classloader because classes it depends on could not be found in the classpath...");
            e.printStackTrace();
        }
        log = LogFactory.getLog((Class)ResourceServerServlet.class);
    }

    public static class ResourceMapping {
        private String resource;
        private String contentType;

        public String getResource() {
            return this.resource;
        }

        public void setResource(String inResource) {
            this.resource = inResource;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String inContentType) {
            this.contentType = inContentType;
        }

        public String toString() {
            String str = null;
            StringBuffer sb = new StringBuffer(1000);
            sb.append("[" + super.toString() + "]={");
            boolean firstPropertyDisplayed = false;
            try {
                Field[] fields = this.getClass().getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (firstPropertyDisplayed) {
                        sb.append(", ");
                    } else {
                        firstPropertyDisplayed = true;
                    }
                    sb.append(fields[i].getName() + "=" + fields[i].get(this));
                }
                sb.append("}");
                str = sb.toString().trim();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            return str;
        }
    }
}

