/*
 * Decompiled with CFR 0.152.
 */
package javawebparts.servlet;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextRendererServlet
extends HttpServlet {
    private static Log log;
    private String initFontName;
    private Integer initFontPoint;
    private String initStylePlain;
    private String initStyleBold;
    private String initStyleItalic;
    private Integer initColR;
    private Integer initColG;
    private Integer initColB;
    private Integer initBackR;
    private Integer initBackG;
    private Integer initBackB;

    public void init(ServletConfig config) throws ServletException {
        StringTokenizer st;
        super.init(config);
        log.info((Object)"init()...");
        String inFontName = config.getInitParameter("fontName");
        String inFontPoint = config.getInitParameter("fontPoint");
        String inStylePlain = config.getInitParameter("stylePlain");
        String inStyleBold = config.getInitParameter("styleBold");
        String inStyleItalic = config.getInitParameter("styleItalic");
        String inColor = config.getInitParameter("color");
        String inBackColor = config.getInitParameter("backColor");
        this.initFontName = inFontName == null ? "Arial" : inFontName;
        this.initFontPoint = inFontPoint == null ? new Integer(12) : new Integer(Integer.parseInt(inFontPoint));
        this.initStylePlain = inStylePlain == null ? "true" : inStylePlain;
        this.initStyleBold = inStyleBold == null ? "true" : inStyleBold;
        this.initStyleItalic = inStyleItalic == null ? "true" : inStyleItalic;
        if (inColor == null) {
            this.initColR = new Integer(0);
            this.initColG = new Integer(0);
            this.initColB = new Integer(0);
        } else {
            st = new StringTokenizer(inColor, ",");
            this.initColR = new Integer(Integer.parseInt(st.nextToken()));
            this.initColG = new Integer(Integer.parseInt(st.nextToken()));
            this.initColB = new Integer(Integer.parseInt(st.nextToken()));
        }
        if (inBackColor == null) {
            this.initBackR = new Integer(0);
            this.initBackG = new Integer(0);
            this.initBackB = new Integer(0);
        } else {
            st = new StringTokenizer(inBackColor, ",");
            this.initBackR = new Integer(Integer.parseInt(st.nextToken()));
            this.initBackG = new Integer(Integer.parseInt(st.nextToken()));
            this.initBackB = new Integer(Integer.parseInt(st.nextToken()));
        }
        log.info((Object)"init() completed");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out;
        StringTokenizer st;
        log.info((Object)"TextRendererServlet.doPost()...");
        String inFontName = request.getParameter("fontName");
        String inFontPoint = request.getParameter("fontPoint");
        String inStylePlain = request.getParameter("stylePlain");
        String inStyleBold = request.getParameter("styleBold");
        String inStyleItalic = request.getParameter("styleItalic");
        String inColor = request.getParameter("color");
        String inBackColor = request.getParameter("backColor");
        String text = request.getParameter("text");
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (inFontName == null) {
            m.put("fontName", this.initFontName);
        } else {
            m.put("fontName", inFontName);
        }
        if (inFontPoint == null) {
            m.put("fontPoint", this.initFontPoint);
        } else {
            m.put("fontPoint", new Integer(Integer.parseInt(inFontPoint)));
        }
        if (inStylePlain == null) {
            m.put("stylePlain", this.initStylePlain);
        } else {
            m.put("stylePlain", inStylePlain);
        }
        if (inStyleBold == null) {
            m.put("styleBold", this.initStyleBold);
        } else {
            m.put("styleBold", inStyleBold);
        }
        if (inStyleItalic == null) {
            m.put("styleItalic", this.initStyleItalic);
        } else {
            m.put("styleItalic", inStyleItalic);
        }
        if (inColor == null) {
            m.put("colR", this.initColR);
            m.put("colG", this.initColG);
            m.put("colB", this.initColB);
        } else {
            st = new StringTokenizer(inColor, ",");
            m.put("colR", new Integer(Integer.parseInt(st.nextToken())));
            m.put("colG", new Integer(Integer.parseInt(st.nextToken())));
            m.put("colB", new Integer(Integer.parseInt(st.nextToken())));
        }
        if (inBackColor == null) {
            m.put("backR", this.initBackR);
            m.put("backG", this.initBackG);
            m.put("backB", this.initBackB);
        } else {
            st = new StringTokenizer(inBackColor, ",");
            m.put("backR", new Integer(Integer.parseInt(st.nextToken())));
            m.put("backG", new Integer(Integer.parseInt(st.nextToken())));
            m.put("backB", new Integer(Integer.parseInt(st.nextToken())));
        }
        m.put("text", text);
        log.info(m);
        OutputStream os = TextRendererServlet.renderText(m);
        if (response != null && (out = response.getOutputStream()) != null) {
            ((ByteArrayOutputStream)os).writeTo((OutputStream)out);
        }
    }

    public static OutputStream renderText(Map m) throws IOException {
        int colR = (Integer)m.get("colR");
        int colG = (Integer)m.get("colG");
        int colB = (Integer)m.get("colB");
        int backR = (Integer)m.get("backR");
        int backG = (Integer)m.get("backG");
        int backB = (Integer)m.get("backB");
        int fontPoint = (Integer)m.get("fontPoint");
        String fontName = (String)m.get("fontName");
        String stylePlain = (String)m.get("stylePlain");
        String styleBold = (String)m.get("styleBold");
        String styleItalic = (String)m.get("styleItalic");
        String text = (String)m.get("text");
        if (stylePlain == null) {
            stylePlain = "false";
        }
        if (styleBold == null) {
            styleBold = "false";
        }
        if (styleItalic == null) {
            styleItalic = "false";
        }
        int fontStyle = 0;
        if (stylePlain.equalsIgnoreCase("true")) {
            fontStyle = 0;
        } else if (styleBold.equalsIgnoreCase("true") && styleItalic.equalsIgnoreCase("false")) {
            fontStyle = 1;
        } else if (styleBold.equalsIgnoreCase("false") && styleItalic.equalsIgnoreCase("true")) {
            fontStyle = 2;
        } else if (styleBold.equalsIgnoreCase("true") && styleItalic.equalsIgnoreCase("true")) {
            fontStyle = 3;
        }
        if (text == null || text.equalsIgnoreCase("")) {
            text = " ";
        }
        Font f = new Font(fontName, fontStyle, fontPoint);
        BufferedImage fmimg = new BufferedImage(10, 10, 1);
        Graphics2D fmg = fmimg.createGraphics();
        fmg.setFont(f);
        FontMetrics fm = fmg.getFontMetrics();
        int width = fm.stringWidth(text) + 8;
        int height = fm.getHeight();
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g = img.createGraphics();
        g.setBackground(new Color(backR, backG, backB));
        g.clearRect(0, 0, width, height);
        g.setColor(new Color(colR, colG, colB));
        g.setFont(f);
        g.drawString(text, 4, fm.getAscent());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "jpg", baos);
        return baos;
    }

    static {
        try {
            Class.forName("javax.servlet.http.HttpServlet");
            Class.forName("javax.servlet.http.HttpServletRequest");
            Class.forName("javax.servlet.http.HttpServletResponse");
            Class.forName("javax.servlet.ServletConfig");
            Class.forName("javax.servlet.ServletException");
            Class.forName("javax.servlet.ServletOutputStream");
            Class.forName("org.apache.commons.logging.Log");
            Class.forName("org.apache.commons.logging.LogFactory");
        }
        catch (ClassNotFoundException e) {
            System.err.println("TextRendererServlet could not be loaded by classloader because classes it depends on could not be found in the classpath...");
            e.printStackTrace();
        }
        log = LogFactory.getLog((Class)TextRendererServlet.class);
    }
}

