/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class LABELItemHandler
implements ItemHandler {
    LABELItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        String label = item.getDecodedValue();
        Address addr = ct.getLastAddedAddress();
        if (addr == null) {
            return;
        }
        addr.setLabel(label);
    }

    public versitItem[] createItems(Contact ct) {
        versitItem[] items = new versitItem[ct.getAddressCount()];
        int i = 0;
        Iterator iter = ct.getAddresses();
        while (iter.hasNext()) {
            Address adr = (Address)iter.next();
            if (adr == null) {
                return new versitItem[0];
            }
            String label = adr.getLabel();
            if (!StringUtil.isValidString(label)) {
                return new versitItem[0];
            }
            versitItem item = new versitItem("LABEL");
            if (adr.isDomestic()) {
                item.addParameter("TYPE", "DOM");
            }
            if (adr.isInternational()) {
                item.addParameter("TYPE", "INTL");
            }
            if (adr.isPostal()) {
                item.addParameter("TYPE", "POSTAL");
            }
            if (adr.isParcel()) {
                item.addParameter("TYPE", "PARCEL");
            }
            if (adr.isHome()) {
                item.addParameter("TYPE", "HOME");
            }
            if (adr.isWork()) {
                item.addParameter("TYPE", "WORK");
            }
            if (ct.isPreferredAddress(adr)) {
                item.addParameter("TYPE", "PREF");
            }
            item.setValue(new String(EncodingUtility.encodeLineBreaks(label.getBytes())));
            items[i] = item;
            ++i;
        }
        return items;
    }
}

