/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.GeographicalInformation;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class TZItemHandler
implements ItemHandler {
    TZItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        String t;
        GeographicalInformation geoinfo = ct.getGeographicalInformation();
        if (geoinfo == null) {
            geoinfo = Pim.getContactModelFactory().createGeographicalInformation();
            ct.setGeographicalInformation(geoinfo);
        }
        if (!StringUtil.isValidString(t = item.getDecodedValue())) {
            return;
        }
        String[] tz = this.processTZ(t);
        geoinfo.setTimeZone(new SimpleTimeZone(this.getOffset(tz), this.getStdID(tz)));
    }

    public versitItem[] createItems(Contact ct) {
        GeographicalInformation geo = ct.getGeographicalInformation();
        if (geo == null) {
            return new versitItem[0];
        }
        TimeZone timez = geo.getTimeZone();
        if (timez == null) {
            return new versitItem[0];
        }
        String tzid = timez.getID();
        timez.setID("none");
        String tz = timez.getDisplayName();
        timez.setID(tzid);
        if (!StringUtil.isValidString(tz)) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        versitItem item = new versitItem("TZ");
        item.setValue(tz.substring(3, tz.length()));
        items[0] = item;
        return items;
    }

    private int getOffset(String[] tz) {
        int offset = 0;
        try {
            offset = 60 * Integer.parseInt(tz[1]);
            offset += Integer.parseInt(tz[2]);
            if (tz[0].equals("-")) {
                offset = -1 * offset;
            }
        }
        catch (NumberFormatException numex) {
            return -1;
        }
        offset = offset * 60 * 1000;
        return offset;
    }

    private String getStdID(String[] tz) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(tz[0]);
        sbuf.append(tz[1]);
        if (tz[2] != null && tz[2].length() > 0) {
            sbuf.append(":").append(tz[2]);
        }
        return sbuf.toString();
    }

    private String[] processTZ(String value) {
        String[] retval = new String[3];
        retval[0] = value.substring(0, 1);
        int colon = value.indexOf(58);
        if (colon > 0) {
            if (value.length() > 6) {
                value = value.substring(0, 6);
            }
            retval[1] = value.substring(1, 3);
            retval[2] = value.substring(4, 6);
        } else {
            if (value.length() > 5) {
                value = value.substring(0, 6);
            }
            retval[1] = value.substring(1, 3);
            retval[2] = value.length() > 3 ? value.substring(3, 5) : "";
        }
        return retval;
    }
}

