/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.openejb.loader.ClassPath;
import sun.misc.URLClassPath;

public abstract class BasicURLClassPath
implements ClassPath {
    private Field ucpField;
    static /* synthetic */ Class class$java$net$URLClassLoader;

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected void addJarToPath(URL jar, URLClassLoader loader) throws Exception {
        this.getURLClassPath(loader).addURL(jar);
    }

    protected void addJarsToPath(File dir, URLClassLoader loader) throws Exception {
        if (dir == null || !dir.exists()) {
            return;
        }
        String[] jarNames = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        URL[] jars = new URL[jarNames.length];
        for (int j = 0; j < jarNames.length; ++j) {
            jars[j] = new File(dir, jarNames[j]).toURL();
        }
        URLClassPath path = this.getURLClassPath(loader);
        for (int i = 0; i < jars.length; ++i) {
            path.addURL(jars[i]);
        }
    }

    protected URLClassPath getURLClassPath(URLClassLoader loader) throws Exception {
        return (URLClassPath)this.getUcpField().get(loader);
    }

    private Field getUcpField() throws Exception {
        if (this.ucpField == null) {
            this.ucpField = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Field ucp = null;
                    try {
                        ucp = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = BasicURLClassPath.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredField("ucp");
                        ucp.setAccessible(true);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    return ucp;
                }
            });
        }
        return this.ucpField;
    }
}

