/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.io.File;
import org.openejb.loader.ClassPath;
import org.openejb.loader.SystemInstance;
import org.openejb.util.FileUtils;

public class Embedder {
    private final String className;
    private String NO_HOME = "The openejb.home is not set.";
    private String BAD_HOME = "Invalid openejb.home: ";
    private String NOT_THERE = "The path specified does not exist.";
    private String NOT_DIRECTORY = "The path specified is not a directory.";
    private String NO_LIBS = "The path specified is not correct, it does not contain any OpenEJB libraries.";
    private String INSTRUCTIONS = "Please edit the web.xml of the openejb_loader webapp and set the openejb.home init-param to the full path where OpenEJB is installed.";

    public Embedder(String className) {
        this.className = className;
    }

    public Class load() throws Exception {
        ClassPath classPath = SystemInstance.get().getClassPath();
        ClassLoader classLoader = classPath.getClassLoader();
        try {
            return classLoader.loadClass(this.className);
        }
        catch (Exception e) {
            return this.forcefulLoad(classPath, classLoader);
        }
    }

    private Class forcefulLoad(ClassPath classPath, ClassLoader classLoader) throws Exception {
        try {
            this.checkOpenEjbHome(SystemInstance.get().getHome().getDirectory());
            FileUtils home = SystemInstance.get().getHome();
            classPath.addJarsToPath(home.getDirectory("lib"));
        }
        catch (Exception e2) {
            throw new Exception("Could not load OpenEJB libraries. Exception: " + e2.getClass().getName() + " " + e2.getMessage());
        }
        try {
            return classLoader.loadClass(this.className);
        }
        catch (Exception e2) {
            throw new Exception("Could not load class '" + this.className + "' after embedding libraries. Exception: " + e2.getClass().getName() + " " + e2.getMessage());
        }
    }

    private void checkOpenEjbHome(File openejbHome) throws Exception {
        try {
            File openejbHomeLibs;
            String homePath = openejbHome.getAbsolutePath();
            if (!openejbHome.exists()) {
                this.handleError(this.BAD_HOME + homePath, this.NOT_THERE, this.INSTRUCTIONS);
            }
            if (!openejbHome.isDirectory()) {
                this.handleError(this.BAD_HOME + homePath, this.NOT_DIRECTORY, this.INSTRUCTIONS);
            }
            if (!(openejbHomeLibs = new File(openejbHome, "lib")).exists()) {
                this.handleError(this.BAD_HOME + homePath, this.NO_LIBS, this.INSTRUCTIONS);
            }
            String[] libs = openejbHomeLibs.list();
            boolean found = false;
            for (int i = 0; i < libs.length && !found; ++i) {
                found = libs[i].startsWith("openejb-") && libs[i].endsWith(".jar");
            }
            if (!found) {
                this.handleError(this.BAD_HOME + homePath, this.NO_LIBS, this.INSTRUCTIONS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleError(String m1, String m2, String m3) throws Exception {
        System.err.println("--[PLEASE FIX]-------------------------------------");
        System.err.println(m1);
        System.err.println(m2);
        System.err.println(m3);
        System.err.println("---------------------------------------------------");
        throw new Exception(m1 + " " + m2 + " " + m3);
    }

    private void handleError(String m1, String m2) throws Exception {
        System.err.println("--[PLEASE FIX]-------------------------------------");
        System.err.println(m1);
        System.err.println(m2);
        System.err.println("---------------------------------------------------");
        throw new Exception(m1 + " " + m2);
    }
}

