/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openejb.loader.ClassPath;
import org.openejb.loader.ClassPathFactory;
import org.openejb.util.FileUtils;

public class SystemInstance {
    private final long startTime = System.currentTimeMillis();
    private final Properties properties;
    private final FileUtils home;
    private final FileUtils base;
    private final ClassLoader classLoader;
    private final HashMap components = new HashMap();
    private final ClassPath classPath;
    private static SystemInstance system;
    private static boolean initialized;

    private SystemInstance(Properties properties) throws Exception {
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)System.getProperties());
        this.properties.putAll((Map<?, ?>)properties);
        this.home = new FileUtils("openejb.home", "user.dir", this.properties);
        this.base = new FileUtils("openejb.base", "openejb.home", this.properties);
        this.classPath = ClassPathFactory.createClassPath(this.properties.getProperty("openejb.loader", "context"));
        this.classLoader = this.classPath.getClassLoader();
        this.properties.setProperty("openejb.home", this.home.getDirectory().getCanonicalPath());
        this.properties.setProperty("openejb.base", this.base.getDirectory().getCanonicalPath());
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    public FileUtils getHome() {
        return this.home;
    }

    public FileUtils getBase() {
        return this.base;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Object getObject(String name) {
        return this.components.get(name);
    }

    public Object setObject(String name, Object value) {
        return this.components.put(name, value);
    }

    public static void init(Properties properties) throws Exception {
        if (initialized) {
            return;
        }
        system = new SystemInstance(properties);
        initialized = true;
    }

    public static SystemInstance get() {
        return system;
    }

    static {
        try {
            system = new SystemInstance(System.getProperties());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create default instance of SystemInstance", e);
        }
    }
}

