/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.openejb.loader.BasicURLClassPath;
import sun.misc.URLClassPath;

public class TomcatClassPath
extends BasicURLClassPath {
    private final ClassLoader classLoader;
    private Method addRepositoryMethod;
    private Method addURLMethod;
    private Method getLoaderMethod;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$sun$misc$URLClassPath;
    static /* synthetic */ Class class$java$lang$String;

    public TomcatClassPath() {
        this(TomcatClassPath.getCommonLoader(TomcatClassPath.getContextClassLoader()).getParent());
    }

    public TomcatClassPath(ClassLoader classLoader) {
        this.classLoader = classLoader;
        try {
            this.addRepositoryMethod = this.getAddRepositoryMethod();
        }
        catch (Exception tomcat4Exception) {
            try {
                this.addURLMethod = this.getAddURLMethod();
            }
            catch (Exception tomcat5Exception) {
                throw new RuntimeException("Failed accessing classloader for Tomcat 4 or 5", tomcat5Exception);
            }
            try {
                this.getLoaderMethod = this.getLoaderMethod();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static ClassLoader getCommonLoader(ClassLoader loader) {
        if (loader.getClass().getName().equals("org.apache.catalina.loader.StandardClassLoader")) {
            return loader;
        }
        return TomcatClassPath.getCommonLoader(loader.getParent());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addJarsToPath(File dir) throws Exception {
        String[] jarNames = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (jarNames == null) {
            return;
        }
        for (int j = 0; j < jarNames.length; ++j) {
            this.addJarToPath(new File(dir, jarNames[j]).toURL());
        }
        this.rebuild();
    }

    public void addJarToPath(URL jar) throws Exception {
        this._addJarToPath(jar);
        this.rebuild();
    }

    public void _addJarToPath(URL jar) throws Exception {
        if (this.addRepositoryMethod != null) {
            String path = jar.toExternalForm();
            this.addRepositoryMethod.invoke((Object)this.getClassLoader(), path);
        } else {
            this.addURLMethod.invoke((Object)this.getClassLoader(), jar);
            int index = 0;
            while (this.getLoader(index++) != null) {
            }
        }
    }

    private Object getLoader(int i) {
        if (this.getLoaderMethod == null) {
            return null;
        }
        try {
            URLClassPath cp = this.getURLClassPath((URLClassLoader)this.getClassLoader());
            Object object = this.getLoaderMethod.invoke((Object)cp, new Integer(i));
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void rebuild() {
        try {
            URLClassPath cp = this.getURLClassPath((URLClassLoader)this.getClassLoader());
            URL[] urls = cp.getURLs();
            if (urls.length < 1) {
                return;
            }
            StringBuffer path = new StringBuffer(urls.length * 32);
            File s = new File(urls[0].getFile());
            path.append(s.getPath());
            for (int i = 1; i < urls.length; ++i) {
                path.append(File.pathSeparator);
                s = new File(urls[i].getFile());
                path.append(s.getPath());
            }
            System.setProperty("java.class.path", path.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Method getAddURLMethod() throws Exception {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    Class clazz = class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = TomcatClassPath.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader;
                    method = clazz.getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = TomcatClassPath.class$("java.net.URL")) : class$java$net$URL);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return method;
                }
            }
        });
    }

    private Method getLoaderMethod() throws Exception {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    Class clazz = class$sun$misc$URLClassPath == null ? (class$sun$misc$URLClassPath = TomcatClassPath.class$("sun.misc.URLClassPath")) : class$sun$misc$URLClassPath;
                    method = clazz.getDeclaredMethod("getLoader", Integer.TYPE);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return method;
                }
            }
        });
    }

    private Method getAddRepositoryMethod() throws Exception {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    Class<?> clazz = TomcatClassPath.this.getClassLoader().getClass();
                    method = clazz.getDeclaredMethod("addRepository", class$java$lang$String == null ? (class$java$lang$String = TomcatClassPath.class$("java.lang.String")) : class$java$lang$String);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception e2) {
                    throw (IllegalStateException)new IllegalStateException("Unable to find or access the addRepository method in StandardClassLoader").initCause(e2);
                }
            }
        });
    }
}

