/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Validateable;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork.interceptor.PrefixMethodInvocationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWorkflowInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 7563014655616490865L;
    private static final Log _log = LogFactory.getLog((Class)DefaultWorkflowInterceptor.class);
    private static final String VALIDATE_PREFIX = "validate";
    private static final String ALT_VALIDATE_PREFIX = "validateDo";
    private boolean alwaysInvokeValidate = true;

    public void setAlwaysInvokeValidate(String alwaysInvokeValidate) {
        this.alwaysInvokeValidate = Boolean.valueOf(alwaysInvokeValidate);
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        ValidationAware validationAwareAction;
        Object action = invocation.getAction();
        if (action instanceof Validateable) {
            Validateable validateable = (Validateable)action;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invoking validate() on action " + validateable));
            }
            try {
                PrefixMethodInvocationUtil.invokePrefixMethod(invocation, new String[]{VALIDATE_PREFIX, ALT_VALIDATE_PREFIX});
            }
            catch (Exception e) {
                e.printStackTrace();
                _log.warn((Object)"an exception occured while executing the prefix method", (Throwable)e);
            }
            if (this.alwaysInvokeValidate) {
                validateable.validate();
            }
        }
        if (action instanceof ValidationAware && (validationAwareAction = (ValidationAware)action).hasErrors()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Errors on action " + validationAwareAction + ", returning result name 'input'"));
            }
            return "input";
        }
        return invocation.invoke();
    }
}

