/*
 * Decompiled with CFR 0.152.
 */
package org.acme.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.Query;

@Path(value="/")
public class DbCnxnViaHibernate {
    private static final String className = DbCnxnViaHibernate.class.getName();
    @Inject
    @ApplicationScoped
    MeterRegistry registry;
    private Counter totalBuildsCounter;

    @PostConstruct
    void init() {
        this.totalBuildsCounter = this.registry.counter(className + ".total.builds.count", new String[0]);
        this.totalBuildsCounter.increment((double)this.getLatestTotalCountOfBuilds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLatestTotalCountOfBuilds() {
        Integer count = 0;
        try (Session session = null;){
            SessionFactory sessionFactory = new Configuration().configure().buildSessionFactory();
            if (sessionFactory == null) {
                System.out.println("buildSessionFactory() returned null");
                int n = -1;
                return n;
            }
            session = sessionFactory.openSession();
            if (session == null) {
                System.out.println("sessionFactory.openSession() returned null");
                int n = -1;
                return n;
            }
            session.beginTransaction();
            String qry = "SELECT count(*) FROM _archived_buildrecords WHERE temporarybuild == FALSE";
            Query countQry = session.createQuery(qry);
            List rs = countQry.getResultList();
            count = (Integer)rs.get(0);
            System.out.println("Records count = " + count);
            session.getTransaction().commit();
        }
        return count;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/count")
    public double getCurrentTotalBuildsCount() {
        this.totalBuildsCounter.increment();
        System.out.println("getCurrentTotalBuildsCount = " + this.totalBuildsCounter.count());
        return this.totalBuildsCounter.count();
    }
}

