/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.parser;

import java.util.ArrayList;
import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParsedWord;
import org.aesh.parser.ParserStatus;

public class LineParser {
    private static final char NULL_CHAR = '\u0000';
    private static final char SPACE_CHAR = ' ';
    private static final char BACK_SLASH = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';

    public static ParsedLine parseLine(String text) {
        return LineParser.parseLine(text, -1);
    }

    public static ParsedLine parseLine(String text, int cursor) {
        ArrayList<ParsedWord> textList = new ArrayList<ParsedWord>();
        boolean haveEscape = false;
        boolean haveSingleQuote = false;
        boolean haveDoubleQuote = false;
        boolean ternaryQuote = false;
        StringBuilder builder = new StringBuilder();
        char prev = '\u0000';
        int index = 0;
        int cursorWord = -1;
        int wordCursor = -1;
        for (char c : text.toCharArray()) {
            if (cursor == index && (prev != ' ' || haveEscape)) {
                cursorWord = textList.size();
                wordCursor = builder.length();
            }
            if (c == ' ') {
                if (haveEscape) {
                    builder.append(c);
                    haveEscape = false;
                } else if (haveSingleQuote || haveDoubleQuote) {
                    builder.append(c);
                } else if (builder.length() > 0) {
                    textList.add(new ParsedWord(builder.toString(), index - builder.length()));
                    builder = new StringBuilder();
                }
            } else if (c == '\\') {
                if (haveEscape || ternaryQuote) {
                    builder.append(c);
                    haveEscape = false;
                } else {
                    haveEscape = true;
                }
            } else if (c == '\'') {
                if (haveEscape || ternaryQuote) {
                    builder.append(c);
                    haveEscape = false;
                } else if (haveSingleQuote) {
                    if (builder.length() > 0) {
                        textList.add(new ParsedWord(builder.toString(), index - builder.length()));
                        builder = new StringBuilder();
                    }
                    haveSingleQuote = false;
                } else if (haveDoubleQuote) {
                    builder.append(c);
                } else {
                    haveSingleQuote = true;
                }
            } else if (c == '\"') {
                if (haveEscape || ternaryQuote && prev != '\"') {
                    builder.append(c);
                    haveEscape = false;
                } else if (haveDoubleQuote) {
                    if (!ternaryQuote && prev == '\"') {
                        ternaryQuote = true;
                    } else if (ternaryQuote && prev == '\"') {
                        if (builder.length() > 0) {
                            builder.deleteCharAt(builder.length() - 1);
                            textList.add(new ParsedWord(builder.toString(), index - builder.length()));
                            builder = new StringBuilder();
                        }
                        haveDoubleQuote = false;
                        ternaryQuote = false;
                    } else {
                        if (builder.length() > 0) {
                            textList.add(new ParsedWord(builder.toString(), index - builder.length()));
                            builder = new StringBuilder();
                        }
                        haveDoubleQuote = false;
                    }
                } else if (haveSingleQuote) {
                    builder.append(c);
                } else {
                    haveDoubleQuote = true;
                }
            } else if (haveEscape) {
                builder.append('\\');
                builder.append(c);
                haveEscape = false;
            } else {
                builder.append(c);
            }
            prev = c;
            ++index;
        }
        if (haveEscape) {
            builder.append('\\');
        }
        if (builder.length() > 0) {
            textList.add(new ParsedWord(builder.toString(), index - builder.length()));
        }
        if (cursor == text.length()) {
            cursorWord = textList.size() - 1;
            if (textList.size() > 0) {
                wordCursor = ((ParsedWord)textList.get(textList.size() - 1)).word().length();
            }
        }
        ParserStatus status = ParserStatus.OK;
        if (haveSingleQuote && haveDoubleQuote) {
            status = ParserStatus.DOUBLE_UNCLOSED_QUOTE;
        } else if (haveSingleQuote || haveDoubleQuote) {
            status = ParserStatus.UNCLOSED_QUOTE;
        }
        return new ParsedLine(text, textList, cursor, cursorWord, wordCursor, status, "");
    }
}

