/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.tty;

import org.aesh.tty.Point;

public class Size {
    private final int height;
    private final int width;

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isPointWithinSize(Point pos) {
        return pos.y() > -1 && pos.x() > -1 && pos.y() < this.height && pos.x() < this.width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size)o;
        if (this.height != size.height) {
            return false;
        }
        return this.width == size.width;
    }

    public int hashCode() {
        int result = this.height;
        result = 31 * result + this.width;
        return result;
    }

    public String toString() {
        return "Size[cols=" + this.width + ", rows=" + this.height + ']';
    }
}

