/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.editing;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.ActionEvent;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.action.mappings.ActionMapper;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.Variable;
import org.aesh.readline.terminal.Key;

public class Emacs
implements EditMode {
    private ActionEvent currentAction;
    private Map<Key, Action> actions = new EnumMap<Key, Action>(Key.class);
    private Map<Variable, String> variables = new EnumMap<Variable, String>(Variable.class);
    private Map<KeyAction, Action> keyEventActions = new HashMap<KeyAction, Action>();
    protected int eofCounter;
    private int ignoreEof = 0;
    private boolean ctrlX;

    Emacs() {
    }

    protected void clearDefaultActions() {
        this.actions.clear();
        this.keyEventActions.clear();
    }

    @Override
    public void addAction(int[] input, String action) {
        Key key = Key.getKey(input);
        if (key != null) {
            this.actions.put(key, ActionMapper.mapToAction(action));
        } else {
            this.keyEventActions.put(this.createKeyEvent(input), ActionMapper.mapToAction(action));
        }
    }

    public void addAction(Key input, String action) {
        this.actions.put(input, ActionMapper.mapToAction(action));
    }

    @Override
    public Emacs addAction(Key input, Action action) {
        this.actions.put(input, action);
        return this;
    }

    private Action parseKeyEventActions(final KeyAction event) {
        for (KeyAction key : this.keyEventActions.keySet()) {
            boolean isEquals = true;
            if (key.length() != event.length()) continue;
            for (int i = 0; i < key.length() && isEquals; ++i) {
                if (key.getCodePointAt(i) == event.getCodePointAt(i)) continue;
                isEquals = false;
            }
            if (!isEquals) continue;
            return this.keyEventActions.get(key);
        }
        if (this.ctrlX) {
            if (event.length() == 1) {
                this.ctrlX = false;
                KeyAction customCtrlX = new KeyAction(){

                    @Override
                    public int getCodePointAt(int index) throws IndexOutOfBoundsException {
                        if (index == 0) {
                            return Key.CTRL_X.getFirstValue();
                        }
                        return event.getCodePointAt(0);
                    }

                    @Override
                    public int length() {
                        return 2;
                    }

                    @Override
                    public String name() {
                        return "Ctrl-x+" + event.name();
                    }
                };
                return this.parseKeyEventActions(customCtrlX);
            }
            this.ctrlX = false;
            return null;
        }
        if (event.getCodePointAt(0) == Key.CTRL_X.getFirstValue()) {
            this.ctrlX = true;
        }
        return null;
    }

    @Override
    public void addVariable(Variable variable, String value) {
        this.variables.put(variable, value);
    }

    @Override
    public void updateIgnoreEOF(int eof) {
        this.ignoreEof = eof;
    }

    protected void resetEOF() {
        this.eofCounter = 0;
    }

    protected int getEofCounter() {
        return this.eofCounter;
    }

    @Override
    public EditMode.Mode mode() {
        return EditMode.Mode.EMACS;
    }

    @Override
    public KeyAction[] keys() {
        ArrayList keys = new ArrayList(this.actions.size() + this.keyEventActions.size());
        this.actions.keySet().forEach(keys::add);
        this.keyEventActions.keySet().forEach(keys::add);
        return keys.toArray(new KeyAction[keys.size()]);
    }

    @Override
    public EditMode.Status status() {
        return EditMode.Status.EDIT;
    }

    @Override
    public void setStatus(EditMode.Status status) {
    }

    @Override
    public Action parse(KeyAction event) {
        if (this.currentAction != null) {
            if (this.currentAction.keepFocus()) {
                this.currentAction.input(this.getAction(event), event);
                return this.currentAction;
            }
            this.currentAction = null;
        }
        return this.getAction(event);
    }

    @Override
    public boolean isInChainedAction() {
        return this.currentAction != null;
    }

    @Override
    public String variableValue(Variable variable) {
        return this.variables.get((Object)variable);
    }

    private Action getAction(KeyAction event) {
        Action action = event instanceof Key && this.actions.containsKey(event) ? this.actions.get(event) : this.parseKeyEventActions(event);
        if (action != null && action instanceof ActionEvent) {
            this.currentAction = (ActionEvent)action;
            this.currentAction.input(action, event);
        }
        return action;
    }
}

