/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.utils;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LinePipedInputStream
extends PipedInputStream {
    private static final int NEW_LINE = 10;

    public LinePipedInputStream(int pipeSize) {
        super(pipeSize);
    }

    public LinePipedInputStream(PipedOutputStream src) throws IOException {
        super(src);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int c = this.read();
        if (c < 0) {
            return -1;
        }
        b[off] = (byte)c;
        int rlen = 1;
        if (c == 10) {
            return rlen;
        }
        int enter = -1;
        while (this.in >= 0 && len > 1) {
            int available = this.in > this.out ? Math.min(this.buffer.length - this.out, this.in - this.out) : this.buffer.length - this.out;
            if (available > len - 1) {
                available = len - 1;
            }
            if ((enter = this.findEnter(this.buffer, this.out, this.out + available > len - 1 ? len - 1 : this.out + available)) > -1) {
                available = enter + 1 <= available ? enter + 1 : enter;
            }
            System.arraycopy(this.buffer, this.out, b, off + rlen, available);
            this.out += available;
            rlen += available;
            len -= available;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in == this.out) {
                this.in = -1;
            }
            if (enter <= -1) continue;
            return rlen;
        }
        return rlen;
    }

    private int findEnter(byte[] buffer, int start, int length) {
        for (int i = start; i < length; ++i) {
            if (buffer[i] != 10) continue;
            return i - start;
        }
        return -1;
    }
}

