/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.formatting;

import org.aesh.terminal.formatting.CharacterType;
import org.aesh.terminal.formatting.Color;
import org.aesh.terminal.formatting.TerminalCharacter;
import org.aesh.terminal.formatting.TerminalColor;
import org.aesh.terminal.formatting.TerminalTextStyle;
import org.junit.Assert;
import org.junit.Test;

public class TerminalCharacterTest {
    private static byte BOLD_OFF = (byte)22;

    @Test
    public void testTerminalCharacterAsString() {
        TerminalCharacter character = new TerminalCharacter('c', new TerminalTextStyle(CharacterType.BOLD));
        Assert.assertEquals((Object)("\u001b[" + CharacterType.BOLD.getValue() + ";" + 3 + Color.DEFAULT.getValue() + ";" + 4 + Color.DEFAULT.getValue() + "mc"), (Object)character.toString());
    }

    @Test
    public void testPrevCharacterAsString() {
        TerminalCharacter c1 = new TerminalCharacter('c', new TerminalTextStyle(CharacterType.BOLD));
        Assert.assertEquals((Object)("\u001b[" + CharacterType.BOLD.getValue() + ";" + 3 + Color.DEFAULT.getValue() + ";" + 4 + Color.DEFAULT.getValue() + "mc"), (Object)c1.toString());
        TerminalCharacter c2 = new TerminalCharacter('f', new TerminalColor(Color.DEFAULT, Color.BLUE), new TerminalTextStyle(CharacterType.CROSSED_OUT));
        Assert.assertEquals((Object)("\u001b[" + BOLD_OFF + ";" + CharacterType.CROSSED_OUT.getValue() + ";" + 4 + Color.BLUE.getValue() + "mf"), (Object)c2.toString(c1));
        TerminalCharacter c3 = new TerminalCharacter('f', new TerminalColor(Color.RED, Color.BLUE));
        TerminalCharacter c4 = new TerminalCharacter('f', new TerminalColor(Color.RED, Color.BLUE));
        Assert.assertEquals((Object)"f", (Object)c4.toString(c3));
        c4 = new TerminalCharacter('g', new TerminalColor(Color.RED, Color.BLUE), new TerminalTextStyle(CharacterType.BOLD));
        Assert.assertEquals((Object)("\u001b[" + CharacterType.BOLD.getValue() + "mg"), (Object)c4.toString(c3));
        c3 = new TerminalCharacter('f', new TerminalColor(Color.RED, Color.BLUE), new TerminalTextStyle(CharacterType.BOLD));
        c4 = new TerminalCharacter('g');
        Assert.assertEquals((Object)"\u001b[22;39;49mg", (Object)c4.toString(c3));
        c4 = new TerminalCharacter('g', new TerminalTextStyle(CharacterType.INVERT));
        Assert.assertEquals((Object)"\u001b[22;7;39;49mg", (Object)c4.toString(c3));
    }

    @Test
    public void testEqualsIgnoreCharacter() {
        TerminalCharacter c1 = new TerminalCharacter('a', new TerminalColor(Color.RED, Color.BLUE));
        TerminalCharacter c2 = new TerminalCharacter('b', new TerminalColor(Color.RED, Color.BLUE));
        Assert.assertTrue((boolean)c1.equalsIgnoreCharacter(c2));
    }
}

