/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import java.util.Arrays;
import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.Action;

public class DeletePrevChar
implements Action {
    @Override
    public String name() {
        return "backward-delete-char";
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        if (inputProcessor.getBuffer().getBuffer().isMasking() && inputProcessor.getBuffer().getBuffer().getPrompt().getMask().charValue() == '\u0000') {
            this.deleteWithMaskEnabled(inputProcessor.getBuffer());
            return;
        }
        this.deleteNoMasking(inputProcessor.getBuffer());
    }

    private void deleteNoMasking(ConsoleBuffer consoleBuffer) {
        int cursor = consoleBuffer.getBuffer().getCursor();
        if (cursor > 0) {
            int lineSize = consoleBuffer.getBuffer().length();
            if (cursor > lineSize) {
                cursor = lineSize;
            }
            consoleBuffer.addActionToUndoStack();
            consoleBuffer.getPasteManager().addText(Arrays.copyOfRange(consoleBuffer.getBuffer().getMultiLine(), cursor - 1, cursor));
            consoleBuffer.delete(-1);
        }
    }

    private void deleteWithMaskEnabled(ConsoleBuffer consoleBuffer) {
        if (consoleBuffer.getBuffer().length() > 0) {
            consoleBuffer.delete(-1);
            consoleBuffer.moveCursor(consoleBuffer.getBuffer().length());
        }
    }
}

