/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.editing.Variable;
import org.aesh.readline.terminal.DeviceBuilder;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.TerminalDevice;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Device;
import org.aesh.terminal.tty.Capability;
import org.junit.Assert;
import org.junit.Test;

public class DeviceTest {
    @Test
    public void testAnsiCapabilities() throws Exception {
        TerminalDevice device = DeviceBuilder.builder().name("ansi").build();
        Assert.assertTrue((boolean)device.getBooleanCapability(Capability.auto_right_margin));
        Assert.assertFalse((boolean)device.getBooleanCapability(Capability.auto_left_margin));
        Assert.assertEquals((long)8L, (long)device.getNumericCapability(Capability.max_colors).intValue());
        Assert.assertEquals((long)24L, (long)device.getNumericCapability(Capability.lines).intValue());
        Assert.assertEquals((Object)"^M", (Object)device.getStringCapability(Capability.carriage_return));
        String cuf = device.getStringCapability(Capability.parm_right_cursor);
        System.out.println("CUF: " + cuf);
        ArrayList out = new ArrayList();
        Consumer<int[]> capabilityConsumer = out::add;
        device.puts(capabilityConsumer, Capability.carriage_return);
        Assert.assertArrayEquals((int[])new int[]{13}, (int[])((int[])out.get(0)));
        Assert.assertArrayEquals((int[])new int[]{27, 91, 72}, (int[])device.getStringCapabilityAsInts(Capability.key_home));
    }

    @Test
    public void testWindowsCapabilities() throws Exception {
        TerminalDevice device = DeviceBuilder.builder().name("windows").build();
        Assert.assertTrue((boolean)device.getBooleanCapability(Capability.move_standout_mode));
        Assert.assertEquals((long)8L, (long)device.getNumericCapability(Capability.max_colors).intValue());
        Assert.assertEquals((long)64L, (long)device.getNumericCapability(Capability.max_pairs).intValue());
        Assert.assertArrayEquals((int[])new int[]{10}, (int[])device.getStringCapabilityAsInts(Capability.scroll_forward));
    }

    @Test
    public void testEmacsKeyUpdates() {
        TerminalDevice device = DeviceBuilder.builder().name("ansi").build();
        EditMode emacs = EditModeBuilder.builder().addVariable(Variable.EDITING_MODE, "emacs").device((Device)device).create();
        Assert.assertEquals((Object)"beginning-of-line", (Object)emacs.parse((KeyAction)Key.HOME_2).name());
    }

    @Test
    public void testXTermCapabilities() throws Exception {
        TerminalDevice device = DeviceBuilder.builder().name("xterm-256color").build();
        Consumer<int[]> output = ints -> Assert.assertEquals((Object)"\u001b[H\u001b[2J", (Object)Parser.fromCodePoints((int[])ints));
        device.puts(output, Capability.clear_screen);
    }
}

