/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.formatting;

import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.junit.Assert;
import org.junit.Test;

public class TerminalStringTest {
    @Test
    public void testTerminalString() {
        TerminalString string = new TerminalString("foo");
        Assert.assertFalse((boolean)string.containSpaces());
        Assert.assertFalse((boolean)string.isFormatted());
        Assert.assertEquals((Object)"foo", (Object)string.getCharacters());
        string = new TerminalString("foo bar", new TerminalColor(Color.BLACK, Color.WHITE));
        Assert.assertTrue((boolean)string.containSpaces());
        Assert.assertTrue((boolean)string.isFormatted());
        Assert.assertEquals((Object)"foo bar", (Object)string.getCharacters());
        string.switchSpacesToEscapedSpaces();
        Assert.assertEquals((Object)"foo\\ bar", (Object)string.getCharacters());
        Assert.assertEquals((Object)"\u001b[;30;47mfoo\\ bar\u001b[0m", (Object)string.toString());
        string = new TerminalString("foo bar", true);
        Assert.assertTrue((boolean)string.containSpaces());
        Assert.assertFalse((boolean)string.isFormatted());
        Assert.assertEquals((Object)"foo bar", (Object)string.getCharacters());
        Assert.assertEquals((long)0L, (long)string.getANSILength());
    }
}

