/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.utils;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.aesh.readline.terminal.utils.LinePipedInputStream;
import org.aesh.utils.Config;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class LinePipedInputStreamTest {
    @Before
    public void beforeMethod() {
        Assume.assumeFalse((boolean)Config.isWindows());
    }

    @Test
    public void testInputStream() throws IOException {
        PipedOutputStream outputStream = new PipedOutputStream();
        LinePipedInputStream pipedInputStream = new LinePipedInputStream(outputStream);
        int numberOfLines = 0;
        String filename = "src" + Config.getPathSeparator() + "test" + Config.getPathSeparator() + "resources" + Config.getPathSeparator() + "input_stream.txt";
        for (String line : Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8)) {
            try {
                ++numberOfLines;
                outputStream.write((line + Config.getLineSeparator()).getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        outputStream.flush();
        int numberOfPipedLines = 0;
        byte[] bBuf = new byte[1024];
        for (String line : Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8)) {
            try {
                int read = pipedInputStream.read(bBuf);
                String in = new String(bBuf, 0, read);
                Assert.assertEquals((Object)(line + Config.getLineSeparator()), (Object)in);
                ++numberOfPipedLines;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((long)numberOfLines, (long)numberOfPipedLines);
    }
}

