/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;

public class EchoShellFactory
implements Factory<Command> {
    public Command create() {
        return new EchoShell();
    }

    public static class EchoShell
    implements Command,
    Runnable {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private Environment environment;
        private Thread thread;

        public InputStream getIn() {
            return this.in;
        }

        public OutputStream getOut() {
            return this.out;
        }

        public OutputStream getErr() {
            return this.err;
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void start(Environment env) throws IOException {
            this.environment = env;
            this.thread = new Thread((Runnable)this, "EchoShell");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void destroy() {
            this.thread.interrupt();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            BufferedReader r = new BufferedReader(new InputStreamReader(this.in));
            try {
                while (true) {
                    String s;
                    if ((s = r.readLine()) == null) {
                        return;
                    }
                    this.out.write((s + "\n").getBytes(StandardCharsets.UTF_8));
                    this.out.flush();
                    if ("exit".equals(s)) {
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (InterruptedIOException s) {
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                this.callback.onExit(0);
            }
        }
    }
}

