/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.aesh.terminal.telnet.Option;
import org.aesh.terminal.telnet.TelnetHandler;

public abstract class TelnetConnection {
    public static final byte BYTE_IAC = -1;
    public static final byte BYTE_DONT = -2;
    public static final byte BYTE_DO = -3;
    public static final byte BYTE_WONT = -4;
    public static final byte BYTE_WILL = -5;
    public static final byte BYTE_SB = -6;
    public static final byte BYTE_SE = -16;
    private byte[] pendingBuffer = new byte[256];
    private int pendingLength = 0;
    Status status = Status.DATA;
    Byte paramsOptionCode = null;
    byte[] paramsBuffer = null;
    int paramsLength;
    boolean paramsIac = false;
    boolean sendBinary = false;
    boolean receiveBinary = false;
    final TelnetHandler handler;

    public TelnetConnection(TelnetHandler handler) {
        this.handler = handler;
    }

    private void appendToParams(byte b) {
        while (this.paramsLength >= this.paramsBuffer.length) {
            this.paramsBuffer = Arrays.copyOf(this.paramsBuffer, this.paramsBuffer.length + 100);
        }
        this.paramsBuffer[this.paramsLength++] = b;
    }

    public void onInit() {
        this.handler.onOpen(this);
    }

    public abstract void close();

    public final void writeDoOption(Option option) {
        this.send(new byte[]{-1, -3, option.code});
    }

    public final void writeWillOption(Option option) {
        this.send(new byte[]{-1, -5, option.code});
    }

    private void rawWrite(byte[] data, int offset, int length) {
        if (length > 0) {
            if (offset == 0 && length == data.length) {
                this.send(data);
            } else {
                byte[] chunk = new byte[length];
                System.arraycopy(data, offset, chunk, 0, chunk.length);
                this.send(chunk);
            }
        }
    }

    protected abstract void execute(Runnable var1);

    protected abstract void schedule(Runnable var1, long var2, TimeUnit var4);

    protected abstract void send(byte[] var1);

    public void receive(byte[] data) {
        for (byte b : data) {
            this.status.handle(this, b);
        }
        this.flushDataIfNecessary();
    }

    public final void write(byte[] data) {
        if (this.sendBinary) {
            int prev = 0;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != -1) continue;
                this.rawWrite(data, prev, i - prev);
                this.send(new byte[]{-1, -1});
                prev = i + 1;
            }
            this.rawWrite(data, prev, data.length - prev);
        } else {
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] & 0x7F);
            }
            this.send(data);
        }
    }

    protected void onClose() {
        this.handler.onClose();
    }

    protected void onOptionWill(byte optionCode) {
        for (Option option : Option.values()) {
            if (option.code != optionCode) continue;
            option.handleWill(this);
            return;
        }
        this.send(new byte[]{-1, -2, optionCode});
    }

    protected void onOptionWont(byte optionCode) {
        for (Option option : Option.values()) {
            if (option.code != optionCode) continue;
            option.handleWont(this);
            return;
        }
    }

    protected void onOptionDo(byte optionCode) {
        for (Option option : Option.values()) {
            if (option.code != optionCode) continue;
            option.handleDo(this);
            return;
        }
        this.send(new byte[]{-1, -4, optionCode});
    }

    protected void onOptionDont(byte optionCode) {
        for (Option option : Option.values()) {
            if (option.code != optionCode) continue;
            option.handleDont(this);
            return;
        }
    }

    protected void onOptionParameters(byte optionCode, byte[] parameters) {
        for (Option option : Option.values()) {
            if (option.code != optionCode) continue;
            option.handleParameters(this, parameters);
            return;
        }
    }

    private void appendData(byte b) {
        if (this.pendingLength >= this.pendingBuffer.length) {
            this.flushData();
        }
        this.pendingBuffer[this.pendingLength++] = b;
    }

    private void flushDataIfNecessary() {
        if (this.pendingLength > 0) {
            this.flushData();
        }
    }

    private void flushData() {
        byte[] data = Arrays.copyOf(this.pendingBuffer, this.pendingLength);
        this.pendingLength = 0;
        this.handler.onData(data);
    }

    static enum Status {
        DATA{

            @Override
            void handle(TelnetConnection session, byte b) {
                if (b == -1) {
                    if (session.receiveBinary) {
                        session.status = ESC;
                    } else {
                        session.flushDataIfNecessary();
                        session.status = IAC;
                    }
                } else {
                    session.appendData(b);
                }
            }
        }
        ,
        ESC{

            @Override
            void handle(TelnetConnection session, byte b) {
                if (b == -1) {
                    session.appendData((byte)-1);
                } else {
                    session.flushDataIfNecessary();
                    IAC.handle(session, b);
                }
            }
        }
        ,
        IAC{

            @Override
            void handle(TelnetConnection session, byte b) {
                if (b == -3) {
                    session.status = DO;
                } else if (b == -2) {
                    session.status = DONT;
                } else if (b == -5) {
                    session.status = WILL;
                } else if (b == -4) {
                    session.status = WONT;
                } else if (b == -6) {
                    session.paramsBuffer = new byte[100];
                    session.paramsLength = 0;
                    session.status = SB;
                } else {
                    session.handler.onCommand(b);
                    session.status = DATA;
                }
            }
        }
        ,
        SB{

            @Override
            void handle(TelnetConnection session, byte b) {
                if (session.paramsOptionCode == null) {
                    session.paramsOptionCode = b;
                } else if (session.paramsIac) {
                    session.paramsIac = false;
                    if (b == -16) {
                        try {
                            session.onOptionParameters(session.paramsOptionCode, Arrays.copyOf(session.paramsBuffer, session.paramsLength));
                        }
                        finally {
                            session.paramsOptionCode = null;
                            session.paramsBuffer = null;
                            session.status = DATA;
                        }
                    } else if (b == -1) {
                        session.appendToParams((byte)-1);
                    }
                } else if (b == -1) {
                    session.paramsIac = true;
                } else {
                    session.appendToParams(b);
                }
            }
        }
        ,
        DO{

            @Override
            void handle(TelnetConnection session, byte b) {
                try {
                    session.onOptionDo(b);
                }
                finally {
                    session.status = DATA;
                }
            }
        }
        ,
        DONT{

            @Override
            void handle(TelnetConnection session, byte b) {
                try {
                    session.onOptionDont(b);
                }
                finally {
                    session.status = DATA;
                }
            }
        }
        ,
        WILL{

            @Override
            void handle(TelnetConnection session, byte b) {
                try {
                    session.onOptionWill(b);
                }
                finally {
                    session.status = DATA;
                }
            }
        }
        ,
        WONT{

            @Override
            void handle(TelnetConnection session, byte b) {
                try {
                    session.onOptionWont(b);
                }
                finally {
                    session.status = DATA;
                }
            }
        };


        abstract void handle(TelnetConnection var1, byte var2);
    }
}

