/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet.netty;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.aesh.terminal.Connection;
import org.aesh.terminal.telnet.TelnetTtyConnection;
import org.aesh.terminal.telnet.netty.NettyTelnetBootstrap;
import org.aesh.terminal.telnet.util.Helper;

public class NettyTelnetTtyBootstrap {
    private final NettyTelnetBootstrap telnet;
    private boolean outBinary;
    private boolean inBinary;
    private Charset charset = StandardCharsets.UTF_8;

    public NettyTelnetTtyBootstrap() {
        this.telnet = new NettyTelnetBootstrap();
    }

    public String getHost() {
        return this.telnet.getHost();
    }

    public NettyTelnetTtyBootstrap setHost(String host) {
        this.telnet.setHost(host);
        return this;
    }

    public int getPort() {
        return this.telnet.getPort();
    }

    public NettyTelnetTtyBootstrap setPort(int port) {
        this.telnet.setPort(port);
        return this;
    }

    public boolean isOutBinary() {
        return this.outBinary;
    }

    public NettyTelnetTtyBootstrap setOutBinary(boolean outBinary) {
        this.outBinary = outBinary;
        return this;
    }

    public boolean isInBinary() {
        return this.inBinary;
    }

    public NettyTelnetTtyBootstrap setInBinary(boolean inBinary) {
        this.inBinary = inBinary;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public CompletableFuture<?> start(Consumer<Connection> factory) {
        CompletableFuture fut = new CompletableFuture();
        this.start(factory, Helper.startedHandler(fut));
        return fut;
    }

    public CompletableFuture<?> stop() {
        CompletableFuture fut = new CompletableFuture();
        this.stop(Helper.stoppedHandler(fut));
        return fut;
    }

    public void start(Consumer<Connection> factory, Consumer<Throwable> doneHandler) {
        this.telnet.start(() -> new TelnetTtyConnection(this.inBinary, this.outBinary, this.charset, factory), doneHandler);
    }

    public void stop(Consumer<Throwable> doneHandler) {
        this.telnet.stop(doneHandler);
    }
}

