/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.terminal.telnet.TelnetHandler;
import org.aesh.terminal.telnet.netty.NettyTelnetConnection;

public class TelnetChannelHandler
extends ChannelInboundHandlerAdapter {
    private final Supplier<TelnetHandler> factory;
    private NettyTelnetConnection conn;
    private static final Logger LOGGER = Logger.getLogger(TelnetChannelHandler.class.getName());

    public TelnetChannelHandler(Supplier<TelnetHandler> factory) {
        this.factory = factory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        int size = buf.readableBytes();
        byte[] data = new byte[size];
        buf.getBytes(0, data);
        this.conn.receive(data);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.conn = new NettyTelnetConnection(this.factory.get(), ctx);
        this.conn.onInit();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.conn.onClose();
        this.conn = null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.log(Level.WARNING, "IO exception, closing", cause);
        ctx.close();
    }
}

